<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <title>Login</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="public/images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="public/images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="public/fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="public/fonts/icons-alipay.css">
    <link rel="stylesheet" href="public/styles/bootstrap.css">

    <link rel="stylesheet" type="text/css" href="public/styles/styles.css" />
    <link rel="manifest" href="public/_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="192x192" href="public/app/icons/icon-192x192.png">


</head>

<body>
    <!-- preloade -->
    <div class="preload preload-container">
        <div class="preload-logo">
            <div class="spinner"></div>
        </div>
    </div>
    <!-- /preload -->
    <div class="mt-7 login-section">
        <div class="tf-container">
            <form class="tf-form" id="login-form" role="form" method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>
                <h1>Login</h1>
                <div class="group-input">
                    <label>Username</label>
                    <input name="username" type="text" placeholder="john34">
                </div>
                <?php if($errors->has('username')): ?>
                <span class="invalid-feedback" style="display: block;" role="alert">
                    <strong><?php echo e($errors->first('username')); ?></strong>
                </span>
                <br>
                <?php endif; ?>
                <div class="group-input auth-pass-input last">
                    <label>Password</label>
                    <input type="password" name="password" class="password-input" placeholder="Password">
                    <a class="icon-eye password-addon" id="password-addon"></a>
                </div>
                <?php if($errors->has('password')): ?>
                <span class="invalid-feedback" style="display: block;" role="alert">
                    <strong><?php echo e($errors->first('password')); ?></strong>
                </span>
                <?php endif; ?>
                <a href="password/reset" class="auth-forgot-password mt-3">Forgot Password?</a>

                <button type="submit" class="tf-btn accent large">Log In</button>

           
            <p class="mb-9 fw-3 text-center ">Already have a Account? <a href="register" class="auth-link-rg">Sign
                    up</a></p>
        </div>
    </div>





    <script type="text/javascript" src="public/javascript/jquery.min.js"></script>
    <script type="text/javascript" src="public/javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="public/javascript/password-addon.js"></script>
    <script type="text/javascript" src="public/javascript/main.js"></script>
    <script type="text/javascript" src="public/javascript/init.js"></script>


</body>

</html><?php /**PATH /home/uniquesq/goshen-ventures.nakaa.com.ng/resources/views/auth/login.blade.php ENDPATH**/ ?>