<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <title>Register</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="public/images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="public/images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="public/fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="public/fonts/icons-alipay.css">
    <link rel="stylesheet" href="public/styles/bootstrap.css">

    <link rel="stylesheet" type="text/css" href="public/styles/styles.css" />
    <link rel="manifest" href="public/_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="192x192" href="public/app/icons/icon-192x192.png">

</head>

<body>
    <?php
          if(!empty($_GET['ref'])){
              
           $mentor = $_GET['ref'];
          }else{
             $mentor = "mkuu" ;
          }
        ?>
    <!-- preloade -->
    <div class="preload preload-container">
        <div class="preload-logo">
            <div class="spinner"></div>
        </div>
    </div>
    <!-- /preload -->
    <div class="header">
        <div class="tf-container">
            <div class="tf-statusbar br-none d-flex justify-content-center align-items-center">
                <a href="#" class="back-btn"> <i class="icon-left"></i> </a>
            </div>
        </div>
    </div>
    <div class="mt-3 register-section">
        <div class="tf-container">
            <?php if($errors->any()): ?>
            <div id="error-box" class="text-warning">
                <?php echo e($errors->first()); ?>

            </div>
            <?php endif; ?>
            <form role="form" class="tf-form" method="POST" action="<?php echo e(route('register')); ?>">
                <?php echo csrf_field(); ?>
                <h1>Register</h1>
                <input type="hidden" value="<?php echo e($mentor); ?>" name="upline">
                <input type="hidden" value="KENYA" name="country">
                <input type="hidden" value="0.0.0.0" name="ip">
                <div class="group-input">
                    <label>Name</label>
                    <input type="text" name="name" value="">
                </div>
                <div class="group-input">
                    <label>Username</label>
                    <input name="username" type="text" value="">
                </div>
                <div class="group-input">
                    <label>Phone</label>
                    <input type="text" name="phone" value="">
                </div>
                <div class="group-input">
                    <label>Email</label>
                    <input type="email" name="email" value="">
                </div>
                <div class="group-input">
                    <label>Password</label>
                    <input type="password" name="password" placeholder="8-20 characters">
                </div>
                <div class="group-input auth-pass-input last">
                    <label>Confirm Password</label>
                    <input type="password" name="password_confirmation" class="password-input" >
                    <a class="icon-eye password-addon" id="password-addon"></a>
                </div>
                <div class="group-cb mt-5">

                    <input type="checkbox" checked class="tf-checkbox">
                    <label class="fw_3">I agree to <a>Terms and condition</a> </label>
                </div>
                <button type="submit" class="btn btn-success accent large">Create An Account</button>
                
                 
                <a href="login" class="btn btn-link"><p class=" mt-2 " style="text-transform:underline;">Already having an account an account?Login</p></a>

            </form>
            

        </div>
    </div>
    
    <script>
        let deferredPrompt;
        
        window.addEventListener('beforeinstallprompt', (event) => {
          // Prevent Chrome 67 and earlier from automatically showing the prompt
          event.preventDefault();
          // Stash the event so it can be triggered later.
          deferredPrompt = event;
          // Update UI to notify the user they can add to home screen
          showInstallButton();
        });
        
        // Function to show install button when desired action occurs
        function showInstallButton() {
          // Show your install button here or trigger it programmatically
        }
        
        // Event listener for the action that triggers installation
        document.getElementById('loginButton').addEventListener('click', () => {
          // Check if the deferredPrompt is available
          if (deferredPrompt) {
            // Show the install prompt
            deferredPrompt.prompt();
            // Wait for the user to respond to the prompt
            deferredPrompt.userChoice.then((choiceResult) => {
              if (choiceResult.outcome === 'accepted') {
                console.log('User accepted the install prompt');
                // You can track the installation here if needed
              } else {
                console.log('User dismissed the install prompt');
              }
              // Reset the deferredPrompt variable
              deferredPrompt = null;
            });
          }
        });


    </script>

    <script type="text/javascript" src="public/javascript/jquery.min.js"></script>
    <script type="text/javascript" src="public/javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="public/javascript/password-addon.js"></script>
    <script type="text/javascript" src="public/javascript/main.js"></script>
    <script type="text/javascript" src="public/javascript/init.js"></script>


</body>

</html><?php /**PATH /home/uniquesq/goshen-ventures.nakaa.com.ng/resources/views/auth/register.blade.php ENDPATH**/ ?>