<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="multikit">
    <meta name="keywords" content="multikit">
    <title><?php echo e(env('')); ?> - Multi-purpose Html Template</title>
    <link rel="manifest" href="./manifest.json">
    <meta name="theme-color" content="#ff8d2f">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="multikit">
    <meta name="msapplication-TileImage" content="public/assets/images/favicon/1.svg">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="icon" href="public/assets/images/favicon/4.svg" type="image/x-icon">
    <link rel="shortcut icon" href="./" type="image/x-icon">

    <!-- Google font css link  -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="public/assets/css/vendors/bootstrap.css">

    <!-- Loader Normalize css -->
    <link rel="stylesheet" type="text/css" href="public/assets/css/normalize.min.css">

    <!-- Remix Icon css -->
    <link rel="stylesheet" type="text/css" href="public/assets/css/remixicon.css">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="public/assets/css/style.css">
</head>

<body class="financial-color inter-body dark-body">
    <!-- Loader Box Start -->
    <div class="min-loader-wrapper">
        <img src="public/assets/images/loader/financial.gif" class="img-fluid loader" alt="">
        <div class="loader-section financial-color section-left"></div>
        <div class="loader-section financial-color section-right"></div>
    </div>
    <!-- Loader Box End -->

    <!-- authentication start -->
    <div class="financial-authentication">
        <div class="custom-container w-100">
            <div class="logo-content">
                <img src="public/assets/images/favicon/4.svg" class="img-fluid logo" alt="">
                <h2>Sign in</h2>
                <h5>Access your account.</h5>
            </div>
            <form class="form-style-8" method="POST" action="<?php echo e(route('login')); ?>">
                <?php echo csrf_field(); ?>
                <div class="form-group-box">
                    <div class="form-box">
                        <input type="text" class="form-control" name="username" placeholder="Username">
                        <i class="ri-at-line"></i>
                    </div>
                    <?php if($errors->has('username')): ?>
                    <span class="invalid-feedback" style="display: block;" role="alert">
                        <strong><?php echo e($errors->first('username')); ?></strong>
                    </span>
                    <?php endif; ?>
                    <div class="form-box">
                        <input type="password" name="password" class="form-control" placeholder="Password">
                        <i class="ri-lock-line"></i>
                    </div>
                    <?php if($errors->has('password')): ?>
                    <span class="invalid-feedback" style="display: block;" role="alert">
                        <strong><?php echo e($errors->first('password')); ?></strong>
                    </span>
                    <?php endif; ?>
                </div>
                <label class="forgot-text">
                    <a href="password/reset" class="content-color">Forgot password?</a>
                </label>
                <button type="submit" class="financial-btn theme-maroon-btn">Sign in</button>
                <label class="forgot-text text-center">
                    <a href="register" class="content-color">If you are new, Create Now</a>
                </label>
                <label class="auth-divider">
                    <span>Or sign in with</span>
                </label>
            </form>


        </div>
    </div>
    <!-- authentication end -->

    <!-- Theme Option Setting Box Start -->
    <div class="theme-setting-box financial-color">
        <div class="theme-box">
            <button class="theme-icon text-white">
                <i class="ri-menu-line"></i>
            </button>
            <ul class="theme-option">
                <li>
                    <button class="theme-setting-button" id="rtl-btn">
                        <i class="ri-text-direction-r"></i>
                    </button>
                </li>
                <li>
                    <button onclick="location.href = './home';" class="theme-setting-button">
                        <i class="ri-home-3-line"></i>
                    </button>
                </li>
            </ul>
        </div>
    </div>
    <!-- Theme Option Setting Box End -->

    <!-- Bootstrap js-->
    <script src="public/assets/js/vendors/bootstrap/bootstrap.bundle.min.js"></script>

    <!-- Loader js -->
    <script src="public/assets/js/loader.js"></script>

    <!-- Theme js-->
    <script src="public/assets/js/script.js"></script>

    <!-- Theme Settings js-->
    <script src="public/assets/js/theme-setting.js"></script>
</body>

</html><?php /**PATH /home/uniquesq/public_html/resources/views/auth/login.blade.php ENDPATH**/ ?>