<!DOCTYPE html>
<html lang="en">

<head>

    <!-- Title -->
    <title><?php echo e(env('APP_NAME')); ?> - Leading digital investment platform</title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <meta name="theme-color" content="#009688">
    <meta name="author" content="DexignZone">
    <meta name="robots" content="index, follow">
    <meta property="og:image" content="https://w3cart.dexignzone.com/xhtml/social-image.png">
    <meta name="format-detection" content="telephone=no">
    <!-- Favicons Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="./public/assets/images/favicon.png">
    <!-- Stylesheets -->
    <link rel="stylesheet" href="./public/assets/vendor/swiper/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="./public/assets/css/style.css">
    <!-- Animte -->
    <link rel="stylesheet" href="./public/assets/vendor/wow/css/libs/animate.css">
    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@100;200;300;400;500;600;700;800;900;1000&family=Roboto:wght@100;300;400;500;700;900&display=swap"
        rel="stylesheet">
</head>

<body>
    <div class="page-wrapper">

        <!-- splash -->
        <div class="loader-screen" id="splashscreen">
            <div class="main-screen">
                <div class="loader"><img src="./public/assets/images/preloader/cart.svg" class="wow bounceInLeft" alt="">
                </div>
                <div class="title">
                    <span class="wow zoomInUp" data-wow-duration="0.2s" data-wow-delay="1s">W</span>
                    <span class="wow zoomInUp" data-wow-duration="0.3s" data-wow-delay="1s">3</span>
                    <span class="wow zoomInUp" data-wow-duration="0.4s" data-wow-delay="1s">C</span>
                    <span class="wow zoomInUp" data-wow-duration="0.5s" data-wow-delay="1s">A</span>
                    <span class="wow zoomInUp" data-wow-duration="0.6s" data-wow-delay="1s">R</span>
                    <span class="wow zoomInUp" data-wow-duration="0.7s" data-wow-delay="1s">T</span>
                </div>
            </div>
        </div>
        <!-- splash-->

        <!-- Welcome Start -->
        <div class="content-body">
            <div class="welcome-area bg-image" style="background-image: url('assets/images/onboarding/bg.jpg');">
                <div class="welcome-inner">
                    <div class="swiper get-started">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="slide-info">
                                    <div class="started">
                                        <h3 class="title font-w700">Welcome to <?php echo e(env('APP_NAME')); ?>- Your Shopping Partner</h3>
                                        <p>Join us now and embark on a fulfilling shopping adventure with W3Cart. Enjoy
                                            a seamless and secure shopping journey with us.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="slide-info">
                                    <div class="started">
                                        <h3 class="title font-w700">Enter the World of Online Shopping</h3>
                                        <p>Explore curated collections, exclusive deals, and seasonal specials to make
                                            your shopping experience truly unforgettable.</p>
                                    </div>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="slide-info">
                                    <div class="started">
                                        <h3 class="title font-w700">Start Your Shopping Journey Now</h3>
                                        <p>Start exploring now and let your shopping desires take flight. Find the
                                            perfect items that resonate with your style and needs.</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-btn">
                            <div class="swiper-pagination style-1 flex-1"></div>
                        </div>
                    </div>
                </div>
                <div class="bottom-btn container">
                    <a href="login" class="btn btn-primary w-100">Get Started</a>
                </div>
            </div>
        </div>
        <!-- Welcome End -->

    </div>
    <!--**********************************
    Scripts
***********************************-->
    <script src="./public/assets/js/jquery.js"></script>
    <script src="./public/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="./public/assets/vendor/swiper/swiper-bundle.min.js"></script><!-- Swiper -->
    <script src="./public/assets/js/dz.carousel.js"></script><!-- Swiper -->
    <script src="./public/assets/vendor/wow/dist/wow.min.js"></script>
    <script src="./public/assets/js/settings.js"></script>
    <script src="./public/assets/js/custom.js"></script>
    <script>
        new WOW().init();

        var wow = new WOW(
            {
                boxClass: 'wow',      // animated element css class (default is wow)
                animateClass: 'animated', // animation css class (default is animated)
                offset: 50,          // distance to the element when triggering the animation (default is 0)
                mobile: false       // trigger animations on mobile devices (true is default)
            });
        wow.init();	
    </script>
</body>

</html><?php /**PATH /home/uniquesq/flipcarttechnologies.com.ng/resources/views/welcome.blade.php ENDPATH**/ ?>