<!DOCTYPE html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no" />
    <meta name="author" content="Dennis" />

    <!-- Favicon icon-->
    <link rel="shortcut icon" type="image/x-icon" href="./public/assets/images/favicon/favicon.ico" />

    <!-- Color modes -->
    <script src="./public/assets/js/vendors/color-modes.js"></script>

    <!-- Libs CSS -->
    <link href="./public/assets/libs/bootstrap-icons/font/bootstrap-icons.min.css" rel="stylesheet" />
    <link href="./public/assets/libs/@mdi/font/css/materialdesignicons.min.css" rel="stylesheet" />
    <link href="./public/assets/libs/simplebar/dist/simplebar.min.css" rel="stylesheet" />

    <!-- Theme CSS -->
    <link rel="stylesheet" href="./public/assets/css/theme.min.css">

    <title><?php echo e(env('APP_NAME')); ?> | Leading digital platform</title>
</head>

<body>
    <main id="main-wrapper" class="main-wrapper">

        <div class="header">
            <!-- navbar -->
            <div class="navbar-custom navbar navbar-expand-lg">
                <div class="container-fluid px-0">
                    <a class="navbar-brand d-block d-md-none" href="/">
                        <img src="./public/assets/images/logo.png" style="width: 50px;" alt="Image" />
                    </a>

                    <a id="nav-toggle" href="#!" class="ms-auto ms-md-0 me-0 me-lg-3">
                        <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" fill="currentColor" class="bi bi-text-indent-left text-muted" viewBox="0 0 16 16">
                            <path d="M2 3.5a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5zm.646 2.146a.5.5 0 0 1 .708 0l2 2a.5.5 0 0 1 0 .708l-2 2a.5.5 0 0 1-.708-.708L4.293 8 2.646 6.354a.5.5 0 0 1 0-.708zM7 6.5a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm0 3a.5.5 0 0 1 .5-.5h6a.5.5 0 0 1 0 1h-6a.5.5 0 0 1-.5-.5zm-5 3a.5.5 0 0 1 .5-.5h11a.5.5 0 0 1 0 1h-11a.5.5 0 0 1-.5-.5z" />
                        </svg>
                    </a>

                    <div class="d-none d-md-none d-lg-block">
                        <!-- Form -->
                        <form action="#">
                            <div class="input-group">
                                <input class="form-control rounded-3 bg-transparent ps-9" type="search" value="" id="searchInput" placeholder="Search" />
                                <span class="">
                                    <button class="btn position-absolute start-0" type="button">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-search text-dark">
                                            <circle cx="11" cy="11" r="8"></circle>
                                            <line x1="21" y1="21" x2="16.65" y2="16.65"></line>
                                        </svg>
                                    </button>
                                </span>
                            </div>
                        </form>
                    </div>
                    <!--Navbar nav -->
                    <ul class="navbar-nav navbar-right-wrap ms-lg-auto d-flex nav-top-wrap align-items-center ms-4 ms-lg-0">
                      
                        <li class="dropdown stopevent ms-2">
                            <a class="btn btn-ghost btn-icon rounded-circle" href="#!" role="button" id="dropdownNotification" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <i class="icon-xs" data-feather="bell"></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-lg dropdown-menu-end" aria-labelledby="dropdownNotification">
                                <div>
                                    <div class="border-bottom px-3 pt-2 pb-3 d-flex justify-content-between align-items-center">
                                        <p class="mb-0 text-dark fw-medium fs-4">Notifications</p>
                                        <a href="#!" class="text-muted">
                                            <span>
                                                <i class="me-1 icon-xs" data-feather="settings"></i>
                                            </span>
                                        </a>
                                    </div>
                                    <div data-simplebar style="height: 250px">
                                        <!-- List group -->
                                        <ul class="list-group list-group-flush notification-list-scroll">
                                            <!-- List group item -->
                                            <li class="list-group-item bg-light">
                                                <a href="#!" class="text-muted">
                                                    <h5 class="mb-1">CEO</h5>
                                                    <p class="mb-0">Lets keep growing together</p>
                                                </a>
                                            </li>

                                        </ul>
                                    </div>
                                    <div class="border-top px-3 py-2 text-center">
                                        <a href="#!" class="text-inherit">View all Notifications</a>
                                    </div>
                                </div>
                            </div>
                        </li>
                        <!-- List -->
                        <li class="dropdown ms-2">
                            <a class="rounded-circle" href="#!" role="button" id="dropdownUser" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                <div class="avatar avatar-md avatar-indicators avatar-online">
                                    <img alt="avatar" src="./public/assets/images/user.png" class="rounded-circle" />
                                </div>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdownUser">
                                <div class="px-4 pb-0 pt-2">
                                    <div class="lh-1">
                                        <h5 class="mb-1"><?php echo e(Auth::user()->name); ?></h5>
                                        <a href="#!" class="text-inherit fs-6">View my profile</a>
                                    </div>
                                    <div class="dropdown-divider mt-3 mb-2"></div>
                                </div>

                                <ul class="list-unstyled">
                                    <li>
                                        <a class="dropdown-item d-flex align-items-center" href="profile">
                                            <i class="me-2 icon-xxs dropdown-item-icon" data-feather="user"></i>
                                            Edit Profile
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="transactions">
                                            <i class="me-2 icon-xxs dropdown-item-icon" data-feather="activity"></i>
                                            Activity Log
                                        </a>
                                    </li>

                                    <li>
                                        <a class="dropdown-item d-flex align-items-center" href="#!">
                                            <i class="me-2 icon-xxs dropdown-item-icon" data-feather="settings"></i>
                                            Settings
                                        </a>
                                    </li>
                                    <li>
                                        <a class="dropdown-item" href="logout">
                                            <i class="me-2 icon-xxs dropdown-item-icon" data-feather="power"></i>
                                            Sign Out
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- navbar vertical -->

        <!-- Sidebar -->

        <div class="navbar-vertical navbar nav-dashboard">
            <div class="h-100" data-simplebar>
                <!-- Brand logo -->
                <a class="navbar-brand" href="/home">
                    <img src="./public/assets/images/logo.png" alt="dash" />
                </a>
                <!-- Navbar nav -->
                <ul class="navbar-nav flex-column" id="sideNavbar">
                    <!-- Nav item -->


                    <!-- Nav item -->
                    <li class="nav-item">

                        <div class="navbar-heading">MENU</div>
                    </li>
                    <!-- Nav item -->
                    <li class="nav-item">

                        <a class="nav-link has-arrow " href="home">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather feather-home nav-icon me-2 icon-xxs">
                                <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                                <polyline points="9 22 9 12 15 12 15 22"></polyline>
                            </svg>
                            Home
                        </a>
                    </li>
                    <!-- Nav item -->
                    <li class="nav-item">
                        <a class="nav-link has-arrow " href="deposit">
                            <i data-feather="message-square" class="nav-icon me-2 icon-xxs"></i>
                            Deposit
                        </a>
                    </li>
                    <!-- Nav item -->
                    <li class="nav-item">
                        <a class="nav-link has-arrow" href="vip">
                            <i data-feather="shopping-cart" class="nav-icon me-2 icon-xxs"></i>
                            Packages
                        </a>
                    </li>
                    <!-- Nav item -->
                    <li class="nav-item">
                        <a class="nav-link has-arrow" href="profile">
                            <i data-feather="mail" class="nav-icon me-2 icon-xxs"></i>
                            Profile
                        </a>
                    </li>
                    <!-- Nav item -->
                    <li class="nav-item">
                        <a class="nav-link has-arrow  " href="withdraw">
                            <i data-feather="layout" class="nav-icon me-2 icon-xxs"></i>
                            Cashout
                        </a>
                    </li>
                    <!-- Nav item -->
                    <!-- Nav item -->
                    <li class="nav-item">
                        <a class="nav-link  collapsed " href="https://wa.me/+254">
                            <i class="nav-icon me-2 icon-xxs" data-feather="file"></i>
                            support
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link " href="transactions">
                            <i data-feather="folder-plus" class="nav-icon me-2 icon-xxs"></i>
                            Transactions
                        </a>
                    </li>
                    <!-- Nav item -->


                    <li class="nav-item">
                        <a class="nav-link has-arrow  collapsed " href="logout">
                            <i data-feather="corner-left-down" class="nav-icon me-2 icon-xxs"></i>
                            Logout
                        </a>

                    </li>

                    <!-- Nav item -->


                </ul>

            </div>
        </div>


        <!-- page content -->
        <div id="app-content">
            <div class="app-content-area">
                <!--  -->
                <div class="container-fluid">
                   <?php echo $__env->yieldContent('content'); ?>
                </div>
                <!--  -->
            </div>
        </div>
    </main>

    <!-- Scripts -->
    <!-- apexchart js -->

    <!-- Libs JS -->

    <script src="./public/assets/libs/bootstrap/dist/js/bootstrap.bundle.min.js"></script>
    <script src="./public/assets/libs/feather-icons/dist/feather.min.js"></script>
    <script src="./public/assets/libs/simplebar/dist/simplebar.min.js"></script>

    <!-- Theme JS -->
    <script src="./public/assets/js/theme.min.js"></script>

    <script src="./public/assets/libs/apexcharts/dist/apexcharts.min.js"></script>
    <script src="./public/assets/js/vendors/chart.js"></script>


</body>

</html><?php /**PATH /home/uniquesq/td-ameritrade.nakaa.com.ng/resources/views/layouts/main.blade.php ENDPATH**/ ?>