<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\DB;



Route::post('payhero1', function(Request $request){


    // Check if the JSON parsing was successful
     Log::alert($request);
     
     Log::alert($request->response['Amount']);
     
     if(!empty($request->response['MpesaReceiptNumber']))
     {
         //register the trx
         Log::alert($request->response['ResultDesc']);
         //update user balance
         $deposit_amount = ($request->response['Amount']);
         $user = $request->response['ExternalReference'];
         $code = $request->response['MpesaReceiptNumber'];
         //get that user
         $userdetails = DB::table('users')->where('id', $user)->first();
         $current_balance = $userdetails->balance;
         $total_balance = $current_balance + $deposit_amount;
         
         //check if trx exist
         $current_trx = DB::table('deposits')->where('transaction', $code)->get()->count();
         
         if($current_trx == 0)
         {
         
         //add balance
         DB::table('users')->where('id', $user)->update(['balance' => $total_balance]);
         DB::table('deposits')->insert([
             'method' => 'Mpesa', 
             'transaction'=>$code, 
             'username'=>$user, 
             'amount'=>$deposit_amount,
             'status' => 'healthy'
             ]);
             
         }
      
         
     }
    
    //get data
    
    return response($request, 200);
});

Route::post('payhero', function(Request $request){

        // Log the entire request for debugging purposes
        Log::alert($request);
    
        // Check if the JSON parsing was successful
        if (!empty($request['MpesaReceiptNumber'])) {
            // Log specific parts of the response
    
            // Extract necessary data from the response
            $deposit_amount = ($request['Amount']); // Ensure amount is treated as float
            $user_reference = $request['user_reference'];
            $code = $request['MpesaReceiptNumber'];
    
            // Retrieve user details
            $user = DB::table('users')->where('id', $user_reference)->first();
    
            if ($user) {
                // Update user balance
                $current_balance = $user->balance ?? 0;
                $current_deposits = $user->wallet ?? 0;
                $total_balance = $current_balance + $deposit_amount;
                $total_deposits = $current_deposits + $deposit_amount;
    
                // Check if transaction exists
                $current_trx = DB::table('deposits')->where('transaction', $code)->exists();
    
                if (!$current_trx) {
                    // Update user's balance
                    DB::table('users')->where('id', $user->id)->update(['balance' => $total_balance, 'wallet'=> $total_deposits]);
    
                    // Insert deposit record
                    DB::table('deposits')->insert([
                        'method' => 'Mpesa',
                        'transaction' => $code,
                        'username' => $user->id,
                        'amount' => $deposit_amount,
                        'status' => 'healthy'
                    ]);
                }
            }
        }
    
        // Return a response (adjust as needed)
        return response()->json(['message' => 'Transaction processed successfully'], 200);
    }
);