@extends('layouts.main')

@section('content')
<br><hr>
<div class="col-md-18 grid-margin">

    <form method="post" action="withdraw">
        @csrf
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">USER WITHDRAWAL PANEL</h4>
  @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
    @endif

    @if (\Session::has('error'))
    <div class="alert alert-danger">
        <ul>
            <li>{!! \Session::get('error') !!}</li>
        </ul>
    </div>
   @endif
        <p class="card-description"> <small>WITHDRAW YOUR INCOME INSTANTLY!</small>. </p>
  
        <div class="form-group">
          <label>Enter phone No:</label>
          <input type="text" name="phone" value="{{Auth::user()->phone}}" readonly  class="form-control text-dark rounded "  value="" placeholder="Enter wallet or phone" aria-label="Enter wallet or phone "required>
        </div>
        
        <br>
        <div class="form-group">
         <label>Enter Amount in KES</label>
          <input required type="text" name="amount" class="form-control rounded bg-light text-dark " placeholder="Enter Amount" aria-label="Enter Amount" required>
        </div>
        <br>
        <button type="submit" class="btn btn-success w-100 rounded btn-sm">Cashout Funds </button>
      </div>
    </div>
    </form>
    {{-- create table for runing investments --}}
    <?php
    $datas =   DB::table('cashouts')->where('phone', Auth::user()->phone)->get();

    ?>
      <hr>
      <div class="col-lg-18 stretch-card">
        <div class="card">
          <div class="card-body">
            <h4 class="card-title h6">YOUR WITHDRAWAL HISTORY</h4>

            <div class="table-responsive">
              <table class="table table-sm table-contextual">
                <thead class="text-white">
                  <tr>
                    <th> ID </th>
                    <th> AMOUNT </th>
                    <th> MPESA </th>
                    <th> STATUS </th>
                    <th> Date </th>
                  </tr>
                </thead>
                <tbody>
                    @foreach ($datas as $data )


                  <tr class="table-white">
                    <td> {{ $data->id }} </td>
                    <td> KES.{{ number_format($data->amount, 2) }}</td>
                    <td> {{ $data->phone }} </td>
                    <td> {{ $data->status }} </td>
                    <td>{{ $data ->created_at }}</td>

                  </tr>
                  @endforeach
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
   {{-- end of the table --}}
  </div>

@endsection
