@extends('layouts.main')

@section('content')
<br><br>
<div class="container">


    <div class="row m-3">
        <div class="col-md-8">
            <div class="card">
                <div class="card-header">{{ __('INVESTMENTS') }}</div>

                <div class="card-body ">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-warning">{{$errors->first()}}</div>
                    @endif
                    <form method="POST" action="{{ route('wallet') }}">
                        @csrf
                        <h3>My Coin Address</h3>
                        <code>{{ Auth::user()->address }}</code>
                        <hr>
                        <div class="col-md-6 grid-margin stretch-card">
                            <div class="card">
                              <div class="card-body">
                                <h4 class="card-title">Transfer Coins With From Here</h4>
                                <p class="card-description"> multi-wallet  </p>
                                <div class="form-group">
                                  <label>Enter Amount In Ksh</label>
                                  <input type="number" name="amount" class="form-control form-control-lg" placeholder="Enter Amount To Invest" aria-label="Capital">
                                  <br>
                                  <label for="cars">Choose coin:</label><br>
                                  <select name="coin">
                                    <option class="form-control form-control-lg" value="btc">BITCOIN</option>
                                    <option class="form-control form-control-lg" value="eth">ETHEREUM</option>
                                    <option class="form-control form-control-lg" value="mno">MONERO</option>
                                    <option class="form-control form-control-lg" value="ltc">LITECOIN</option>
                                  </select>
                                </div>
                                 <br>
                                <button type="submit" class="btn btn-primary float-right">Invest Now</button>
                              </div>
                            </div>
                          </div>
                    </form>
                </div>
            </div>
        </div>
        {{-- create table for runing investments --}}
        <?php
        $datas =   DB::table('invest')->where('user_id', Auth::user()->id)->get();

        ?>
          <hr>
          <div class="col-lg-12 stretch-card">
            <div class="card">
              <div class="card-body">
                <h4 class="card-title">All coins tranfer history</h4>
                <p class="card-description"> Add class <code>.table-{color}</code>
                </p>
                <div class="table-responsive">
                  <table class="table table-bordered table-contextual">
                    <thead>
                      <tr>
                        <th> # </th>
                        <th> cryptocurrency </th>
                        <th> amount(ksh) </th>
                        <th> recepient </th>
                        <th> Hash</th>
                        <th> status </th>
                      </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data )


                      <tr class="table-info">
                        <td> 1 </td>
                        <td> {{ $data->capital }} </td>
                        <td> {{ $data->returns }} </td>
                        <td> {{ $data->date }} </td>
                        <td> @if ($data->status == 1)
                            completed...
                        @endif
                        @if ($data->status == 2)
                            not confirmed!!
                        @endif

                    </td>
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
       {{-- end of the table --}}
    </div>
</div>
@endsection
