@extends('layouts.main')
@section('content')

        <!-- Main page content -->
        <div class="container">
         
            <div class="row">
                 @if (\Session::has('success'))
                     <center>
                         <div class="alert alert-success w-100">
                           
                           <small>{!! \Session::get('success') !!}</small>
                         
                        </div>
                     </center>
                        
                    @endif
                
                    @if (\Session::has('error'))
                    <center>
                      <div class="alert alert-danger w-100 p-1 m-1">
                        <ul>
                            <li>{!! \Session::get('error') !!}</li>
                        </ul>
                     </div>
                    </center>
                   
                   @endif
                   <?php
                      $products = DB::table('packages')->get();
                  ?>
                @foreach($products as $product)
                  <div class="row rounded m-2 py-1 shadow-sm bg-white">
                      <div class="col-6">
                          <h4 class="item-name">
                              <a href="package?p={{$product->id}}">
                                  MACHINE-{{$product->id}}
                              </a>
                          </h4>
                          <div class="offer-code">
                              <small>{{$product->vip}}</small>
                          </div>
                          <div class="price-wrapper">
                              <h6 class="current-price">KES.{{$product->price}}</h6>
                          </div>
                      </div>
                      <div class="col-auto text-right">
                          @if($product->id < 5)
                              <img class="rounded-sm" style="width:50px;" src="public/{{$product->id}}.png" alt="image">
                          @else
                              <img class="rounded-sm" style="width:50px;" src="public/3.png" alt="image">
                          @endif
                          <div class="footer-wrapper">
                              <span class="product-title"><small>Earn {{$product->daily_income}}% Daily</small></span>
                          </div>
                      </div>
                      <hr>
                      <!-- Ensure unique IDs by appending the product ID -->
                      <input required id="amountInput_{{$product->id}}" class="form-control mb-2" name="amount" placeholder="Enter Capital" />
                      <button id="investmentButton_{{$product->id}}" class="btn btn-sm btn-success w-100" onclick="createInvestment('{{$product->id}}')">Create An Investment</button>
                  </div>
              @endforeach
            </div>

            <!-- Coupon code -->
            <?php
                $datas = DB::table('invest')->where('type', 0)->where('user_id', Auth::user()->id)->get();
            ?>

            <div class="row mt-4">
                <div class="col-md-12">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th class="text-center">Capital</th>
                                <th class="text-center">Returns</th>
                                <th class="text-center">Date Invested</th>
                                <th class="text-center">Days</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($datas as $data)
                            <tr>
                                <td class="text-center">{{ $data->capital }}</td>
                                <td class="text-center">{{ $data->returns }}</td>
                                <td class="text-center">{{ date('Y-m-d H:i:s', strtotime($data->date) + (3 * 3600)) }}</td>
                                <td class="text-center">
                                    @if ($data->status == 1)
                                    {{ $data->days_paid }}
                                    @elseif ($data->status == 2)
                                    Expired!!
                                    @endif
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

            <!-- Optional JavaScript; choose one of the two! -->

          <script>
                function createInvestment(productId) {
                    // Get the amount input based on the product ID
               var amount = document.getElementById('amountInput_' + productId).value;
                    
                    // Check if amount is null or empty
                    if (!amount) {
                        alert("Amount is required. Please enter a value."); // Show an alert if the input is empty
                        document.getElementById('amountInput_' + productId).focus(); // Focus back on the input field
                        return;
                    } else {
                        // Proceed with further processing
                        console.log("Amount entered:", amount);
                    }

                    

                    // Construct the URL with query parameters
                    var redirectUrl = '/package?p=' + encodeURIComponent(productId) + '&amt=' + encodeURIComponent(amount);

                    // Redirect the user to the new URL
                    window.location.href = redirectUrl;
                }
            </script>



        </div>
        <!-- Main page content ends -->
@endsection