@extends('layouts.main')

@section('content')
<br><br>
<div class="container">
    <div class="row">
        <div class="col-md-12 mb-2">
            <div class="card bg-primary">
                <div class="card-header">{{ __('APPLY LOANS') }}</div>

                <div class="card-body ">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-warning">{{$errors->first()}}</div>
                    @endif
                    <form method="#" >
                        @csrf
                        <div class="col-md-12 grid-margin stretch-card">
                            <div class="card m-0 bg-primary">
                              <div class="card-body">
                                <h4 class="card-title">Get Loans To work On Your Daily Needs</h4>
                                <p class="card-description text-dark"> Enter Amount </p>
                                <div class="form-group">
                                  <label></label>
                                  <input type="text" name="amount" readonly value="Your loan Limit is 0.00KES" class="form-control form-control-lg"  aria-label="Capital">
                                </div>
                                <small><code>SAVE MORE TO GET LOANS</code></small>
                                <button type="submit" class="btn btn-success">Apply Loan</button>
                              </div>
                            </div>
                          </div>
                    </form>
                </div>
            </div>
        </div>
        {{-- create table for runing investments --}}
        <?php
        $datas =   DB::table('invest')->where('type', 1)->where('user_id', Auth::user()->id)->get();

        ?>
          <hr>
          <div class="col-lg-12 stretch-card">
            <div class="card bg-success">
              <div class="card-body">
                <h4 class="card-title">User Real-Estates Investment Table</h4>

                </p>
                <div class="table-responsive">
                  <table class="table table-bordered table-contextual">
                    <thead>
                      <tr>
                        <th> # </th>
                        <th> capital </th>
                        <th> daily_income </th>
                        <th> start date </th>
                        <th> status </th>
                      </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data )


                      <tr class="table-info">
                        <td> 1 </td>
                        <td> {{ $data->capital }} </td>
                        <td> {{ $data->returns }} </td>
                        <td> {{ $data->date }} </td>
                        <td> 
                        @if ($data->status == 1)
                            Running...
                        @endif
                        @if ($data->status == 2)
                            Expired!!
                        @endif
                    </td>
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
       {{-- end of the table --}}
    </div>
</div>
@endsection
