@extends('layouts.main')
@section('content')
        @php
        $data = DB::table('coins_trading')->where('user_id', Auth::user()->id)->orderBy('id', 'DESC')->get();
        //echo $exchangeRates['rates']['RUB'];
             //rates of ksh to 1EUR
 //rates of ksh to 1EUR
 $ksh = $exchangeRates['rates']['KES'];
 $rub = $exchangeRates['rates']['RUB'];
 $usd = $exchangeRates['rates']['USD'];
 $aud = $exchangeRates['rates']['AUD'];
 $cad = $exchangeRates['rates']['CAD'];
 $jpy = $exchangeRates['rates']['JPY'];
 $cny = $exchangeRates['rates']['CNY'];
//rate to 1ksh
 $kshTorub = $rub / $ksh;
 //rate to 1usd
 $usdTorub = $rub / $usd;
 //aud
 $kshToaud = $aud / $ksh;
 $usdToaud = $aud / $usd;

 //canada
 $kshTocad = $cad / $ksh ;
 $usdTocad = $cad / $usd;

 //japan
 $kshTojpy = $jpy / $ksh;
 $usdTojpy = $jpy / $usd;
 //china
 $kshTocny = $cny / $ksh;
 $usdTocny = $cny / $usd;
 //usa
 $kshTousd = $usd / $ksh;
 $kshToeur = 1/$ksh;
        //dd ($exchangeRates['rates']);
        @endphp

<div class="col-md-6 grid-margin">
    <div class="card">
      <div class="card-body">
        <h4 class="card-title">Start Trading</h4>
        <p class="card-description"> START TRADING CURRENCY TODAY </p>
                @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
    @endif

    @if (\Session::has('error'))
    <div class="alert alert-danger">
        <ul>
            <li>{!! \Session::get('error') !!}</li>
        </ul>
    </div>
@endif
<form method="post">
    @csrf
        <div class="form-group">
          <label for="exampleFormControlSelect2"> Select The Currency Pair</label>
          <select name="pair" class="form-control text-white" id="exampleFormControlSelect2">
            <option value="USD">KSH/USD</option>
            <option value="RUB">KSH/RUB</option>
            <option value="EUR">KSH/EUR</option>
            <option value="CAD">KSH/CAD</option>
            <option value="JPY">KSH/JPY</option>
            <option value="CNY">KSH/CNY</option>
            <option value="AUD">KSH/AUD</option>

          </select>
        </div>
        <label>Enter Capital To Trade</label>

        <div class="form-group">
            <div class="input-group">
              <div class="input-group-prepend">
                <span class="input-group-text">CAPITAL~(KSH)</span>
              </div>

              <input type="text" name ="capital" class="form-control text-white" aria-label="Amount (to the nearest dollar)">
            </div>
          </div>
        <small><code>leverage is how many timesz we will multiply your profits/loss</code><small>
        <div class="form-group">
          <label for="exampleFormControlSelect3"> Select Leverage</label>
          <select class="form-control form-control-sm text-white" id="exampleFormControlSelect3">
            <option>Leveraage - (1:100)</option>

          </select>
        </div>
        <button type="submit" class="btn btn-success">Initiate Trade</button>
      </div>
    </div>
</form>





        <div class="card">
          <div class="card-body">
            <h4 class="card-title">TRADING HISTORY</h4>
            <p class="card-description">
            </p>
            <div class="table-responsive">
              <table class="table">
                <thead>
                  <tr>
                    <th>capital</th>
                    <th>profit/loss</th>
                    <th>Trade Balance</th>
                    <th>Date/Time</th>
                    <th>Action</th>
                    <th>Asset</th>

                  </tr>
                </thead>
                <tbody>
                    @foreach ($data as $dt)
                    <?php
                           $capital = $dt->amount;
                           $status = $dt ->status;
                           $rate = $dt->rate;
                           $asset = strtolower($dt->asset);
                           $curr = $dt ->asset;
                           switch ($curr) {
                            case 'USD':
                                $closing =  $kshTousd;
                                break;
                             case 'RUB':
                                $closing =  $kshTorub;
                                break;
                            case 'EUR':
                                $closing =  $kshToeur;
                                break;  
                             case 'CAD':
                                $closing =  $kshTocad;
                                break;
                            case 'JPY':
                                $closing =  $kshTojpy;
                                break; 
                            case 'CNY':
                                $closing =  $kshTocny;
                                break;                                
                            case 'AUD':
                                $closing =  $kshToaud;
                                break;                                
                            default:
                                
                                 $closing =  $kshTousd;
                                break;
                        }
                           
                            
                            
                           //$closing = Cryptocap::getSingleAsset($dt->asset)->data->priceUsd;
                           $sell_price = $capital * $closing / $rate;
                           $profit =  ($sell_price - $capital) *10;
                    ?>

                    {{-- capital rate	profit/loss	Date/Time	Action	Status --}}
                  <tr>
                      <form method="post" action="actions">
                          @csrf
                    <td>{{  number_format($dt->amount, 2)}}</td>
                    <td>{{ number_format($profit, 2) }}KSH</td>
                    <td>{{  number_format($sell_price + $profit, 2)}}</td>
                    <td>{{ $dt->date }}</td>
                    <td>

                        @if ($status == "running...")
                        <input type="hidden" name="profit" value="{{  number_format($sell_price + $profit, 2)}}">
                        <input type="hidden" name="id" value="{{  $dt->id}}">
                        <button type="submit" class="badge badge-success">close</button>

                        @endif
                        @if ($status == "closed")
                        <label class="badge badge-info">closed</label>
                        @endif
                    </td>
                    <td>
                        {{$dt->asset}}
                    </td>
                      </form>
                  </tr>


                  @endforeach
                </tbody>
              </table>

          </div>
        </div>
      </div>
              <div class="card">
          <div class="card-body">
            <h4 class="card-title">CURRENT EXCHANGE RATE TO (1EUR)</h4>
            <p class="card-description">
            </p>
            <div class="table-responsive">
              <table class="table">
                <thead>
                  <tr>
                    <th>SYMBOL</th>
                    <th>EUR(RATE)</th>
                    <th>USD(RATE)</th>
                    <th>KSH(RATE)</th>
                    <th>STATE</th>
                  </tr>
                </thead>
                <tbody>
                  <tr>
                    <td>RUB</td>
                    <td>{{$exchangeRates['rates']['RUB']}}</td>
                    <td>{{$usdTorub}}</td>
                    <td>{{$kshTorub}}</td>
                    <td>Russia</td>
                  </tr>
                    <tr>
                    <td>AUD</td>
                    <td>{{$exchangeRates['rates']['AUD']}}</td>
                    <td>{{$usdToaud}}</td>
                    <td>{{$kshToaud}}</td>
                    <td>Australia</td>
                  </tr>
                  
                   <tr>
                    <td>CNY</td>
                    <td>{{$exchangeRates['rates']['CNY']}}</td>
                    <td>{{$usdTocny}}</td>
                    <td>{{$kshTocny}}</td>
                    <td>china</td>
                  </tr>
                  
                    <tr>
                    <td>JPY</td>
                    <td>{{$exchangeRates['rates']['JPY']}}</td>
                    <td>{{$usdTojpy}}</td>
                    <td>{{$kshTojpy}}</td>
                    <td>Japan</td>
                  </tr>  
                    <tr>
                    <td>CAD</td>
                    <td>{{$exchangeRates['rates']['CAD']}}</td>
                    <td>{{$usdTocad}}</td>
                    <td>{{$kshTocad}}</td>
                    <td>Canada</td>
                  </tr>                  

                </tbody>
              </table>

          </div>

        </div>
      </div>
  </div>

@endsection
