<?php

namespace Database\Seeders;

use Illuminate\Support\Facades\DB;

use WisdomDiala\Cryptocap\Facades\Cryptocap;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;

use Illuminate\Database\Seeder;

class CoinsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        DB::table('coin_prices')->insert([
            'name' => "Bitcoin",
            'symbol' => "BTC",
            'price' => Cryptocap::getSingleAsset('bitcoin')->data->priceUsd,
        ]);

        DB::table('coin_prices')->insert([
            'name' => "Ethereum",
            'symbol' => "ETH",
            'price' => Cryptocap::getSingleAsset('Ethereum')->data->priceUsd,
        ]);

        DB::table('coin_prices')->insert([
            'name' => "Litecoin",
            'symbol' => "LTC",
            'price' => Cryptocap::getSingleAsset('litecoin')->data->priceUsd,
        ]);

        DB::table('coin_prices')->insert([
            'name' => "Monero",
            'symbol' => "XMR",
            'price' => Cryptocap::getSingleAsset('bitcoin')->data->priceUsd,
        ]);

    }
}
