<!DOCTYPE html>
<html lang="en">

<head>

    <!-- Title -->
    <title>W3Cart - Ecommerce Mobile App Template ( Bootstrap + PWA )</title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <meta name="theme-color" content="#009688">
    <meta name="author" content="DexignZone">
    <meta name="robots" content="index, follow">
    <meta name="keywords"
        content="android, ios, mobile, application template, progressive web app, ui kit, multiple color, dark layout">
    <meta name="description"
        content="Revolutionize your online store with our Ecommerce App Template. Seamless shopping, secure payments, and personalized recommendations for an exceptional user experience">
    <meta property="og:title" content="W3Cart: Ecommerce Mobile App Template ( Bootstrap + PWA )">
    <meta property="og:description"
        content="Revolutionize your online store with our Ecommerce App Template. Seamless shopping, secure payments, and personalized recommendations for an exceptional user experience.">
    <meta property="og:image" content="https://w3cart.dexignzone.com/xhtml/social-image.png">
    <meta name="format-detection" content="telephone=no">

    <!-- Favicons Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="public/assets/images/favicon.png">

    <!-- Globle Stylesheets -->

    <!-- Stylesheets -->
    <link rel="stylesheet" type="text/css" href="public/assets/css/style.css">

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@100;200;300;400;500;600;700;800;900;1000&family=Roboto:wght@100;300;400;500;700;900&display=swap"
        rel="stylesheet">

</head>

<body>
    <div class="page-wrapper">
        <!-- Preloader -->
        <div id="preloader">
            <div class="loader">
                <div class="load-circle">
                    <div></div>
                    <div></div>
                </div>
            </div>
        </div>
        <!-- Preloader end-->

        <!-- Page Content -->
        <div class="page-content">
            <div class="account-box">
                <div class="container">
                    <div class="logo-area">
                        <img class="logo-dark" src="public/logo.png" alt="">
                        <img class="logo-light" src="public/logo-white.png" alt="">
                    </div>
                    <div class="section-head text-center pt-0">
                        <h2>Welcome back!</h2>
                        <p>Welcome back you've been missed!</p>
                    </div>
                    <div class="account-area">
                        <form id="login-form" role="form" method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="mb-3">
                                <label class="form-label" for="name">Username</label>
                                <input type="text" name="username" id="name" class="form-control"
                                    placeholder="Type Username Here">
                            </div>
                            <?php if($errors->has('username')): ?>
                            <span class="invalid-feedback" style="display: block;" role="alert">
                                <strong><?php echo e($errors->first('username')); ?></strong>
                            </span>
                            <?php endif; ?>
                            <div>
                                <label class="form-label" for="password">Password</label>
                                <div class="mb-3 input-group input-group-icon">
                                    <input type="password" name="password" id="password"
                                        class="form-control dz-password" placeholder="Type Password Here">
                                    <span class="input-group-text show-pass">
                                        <i class="icon feather icon-eye-off eye-close"></i>
                                        <i class="icon feather icon-eye eye-open"></i>
                                    </span>
                                </div>
                                <?php if($errors->has('password')): ?>
                                <span class="invalid-feedback" style="display: block;" role="alert">
                                    <strong><?php echo e($errors->first('password')); ?></strong>
                                </span>
                                <?php endif; ?>

                            </div>
                            <button type="submit" form="login-form" class="btn mb-3 btn-primary w-100">Login</button>
                            <div class="d-flex justify-content-between align-items-center mb-4">
                                <a href="password/reset" class="btn-link">Forgot password?</a>
                                <a href="password/reset" class="btn-link">Reset here</a>
                            </div>
                            <a href="register" class="btn-link text-center mb-3 text-dark">Don’t have an
                                account?</a>
                            <a href="register" class="btn mb-3 btn-outline-primary w-100">Register now</a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
        <!-- Page Content End -->

    </div>
    <!--**********************************
    Scripts
***********************************-->
    <script src="public/assets/js/jquery.js"></script>
    <script src="public/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="public/assets/vendor/swiper/swiper-bundle.min.js"></script><!-- Swiper -->
    <script src="public/assets/js/dz.carousel.js"></script><!-- Swiper -->
    <script src="public/assets/js/settings.js"></script>
    <script src="public/assets/js/custom.js"></script>
</body>

</html><?php /**PATH /home/uniquesq/flipcarttechnologies.com.ng/resources/views/auth/login.blade.php ENDPATH**/ ?>