<!DOCTYPE html>
<html lang="en">

<head>

    <!-- Title -->
    <title><?php echo e(env('APP_NAME')); ?></title>

    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, minimal-ui, viewport-fit=cover">
    <meta name="theme-color" content="#009688">
    <meta name="author" content="DexignZone">
    <meta name="robots" content="index, follow">
    <meta property="og:image" content="https://w3cart.dexignzone.com/xhtml/social-image.png">
    <meta name="format-detection" content="telephone=no">

    <!-- Favicons Icon -->
    <link rel="shortcut icon" type="image/x-icon" href="public/assets/images/favicon.png">

    <!-- PWA Version -->
    <link rel="manifest" href="public/manifest.json">

    <!-- Global CSS -->
    <link href="public/assets/css/bootstrap-select.min.css" rel="stylesheet">
    <link rel="stylesheet" href="public/assets/jquery.bootstrap-touchspin.min.css">
    <link rel="stylesheet" href="public/assets/vendor/swiper/swiper-bundle.min.css">

    <!-- Stylesheets -->
    <link rel="stylesheet" type="text/css" href="public/assets/css/style.css">
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>

    <!-- Google Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=DM+Sans:wght@100;200;300;400;500;600;700;800;900;1000&family=Roboto:wght@100;300;400;500;700;900&display=swap"
        rel="stylesheet">

    <script src="https://kit.fontawesome.com/13a2f60408.js" crossorigin="anonymous"></script>

</head>

<body>

    <?php
    
            $sacco = DB::table('invest')->where('user_id', Auth::user()->id)->sum('capital');              
            $tr = DB::table('invest')->where('type', 10)->where('user_id', Auth::user()->id)->sum('capital');          
            $inv = DB::table('invest')->where('type', 0)->where('user_id', Auth::user()->id)->sum('capital');             
            $daily = DB::table('invest')->where('user_id', Auth::user()->id)->sum('returns');               
            $shares =  DB::table('invest')->where('type', 5)->where('user_id', Auth::user()->id)->sum('capital');              
            $cashout = DB::table('cashouts')->where('username', Auth::user()->username)->sum('amount');              
            $total_trades = DB::table('coins_trading')->where('user_id', Auth::user()->id)->sum('amount');              
            $global_withdrawal = $cashout/100;               
            //user data             
            $balances = Auth::user()->balance;
            $global = $balances / 100;           
            if(Auth::user()->country == 'Kenya'){
                $const = 1;
                $symb = 'KES';
            }elseif(Auth::user()->country == 'Rwanda'){
                 $const = 10;
                 $symb = 'RWF';
            }elseif(Auth::user()->country == 'Tanzania'){
                 $const = 20;
                 $symb = 'TZ';
            }elseif(Auth::user()->country == 'Uganda'){
                 $const = 30;
                 $symb = 'UGX';
            }else{
                $const = 0.01;
                $symb = '$';
            }
            
            $packages = DB::table('packages')->limit(4)->get();
            
      
    ?>

    <div class="page-wrapper">

        <!-- Preloader -->
        <div id="preloader">
            <div class="loader">
                <div class="load-circle">
                    <div></div>
                    <div></div>
                </div>
            </div>
        </div>
        <!-- Preloader end-->

        <!-- Header -->
        <header class="header shadow header-fixed border-0">
            <div class="container">
                <div class="header-content">
                    <div class="left-content">
                        <a href="javascript:void(0);" class="menu-toggler">
                            <i class="fas fa-bars"></i>
                        </a>
                    </div>
                    <div class="mid-content header-logo">
                        <a href="home">
                            <img class="logo app-logo" src="public/long-logo.png" alt="logo">
                        </a>
                    </div>
                    <div class="right-content">
                        <a href="search" class="search-icon">
                            <i class="fas fa-search"></i>
                        </a>
                    </div>
                </div>
            </div>
        </header>
        <!-- Header -->

        <!-- Sidebar -->
        <div class="dark-overlay"></div>
        <div class="sidebar" style="background-image: url('public/assets/images/background/bg3.png');">
            <a href="profile" class="author-box">
                <div class="dz-media">
                    <img src="public/user.png" alt="author-image">
                </div>
                <div class="dz-info">
                    <h5 class="name"><?php echo e(Auth::user()->name); ?></h5>
                    <span><?php echo e(Auth::user()->email); ?></span>
                </div>
            </a>
            <ul class="nav navbar-nav">
                <li>
                    <a class="nav-link active" href="home">
                        <span class="dz-icon">
                            <i class="fas fa-home"></i>
                        </span>
                        <span>Home</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="vip">
                        <span class="dz-icon">
                            <i class="fas fa-credit-card"></i>
                        </span>
                        <span>Products</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="deposit">
                        <span class="dz-icon">
                            <i class="fas fa-wallet"></i>
                        </span>
                        <span>Deposit</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="withdraw">
                        <span class="dz-icon">
                            <i class="fas fa-book-open"></i>
                        </span>
                        <span>Cashout</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="<?php echo e(env('APP_WHATSAPP')); ?>">
                        <span class="dz-icon">
                            <i class="fas fa-list"></i>
                        </span>
                        <span>support</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="transactions">
                        <span class="dz-icon">
                            <i class="fas fa-heart"></i>
                        </span>
                        <span>Transactions</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="downlines">
                        <span class="dz-icon">
                            <i class="fas fa-repeat"></i>
                        </span>
                        <span>Teams</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="cart">
                        <span class="dz-icon">
                            <i class="fas fa-shopping-cart"></i>
                        </span>
                        <span>Download App</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="profile">
                        <span class="dz-icon">
                            <i class="fas fa-user"></i>
                        </span>
                        <span>Profile</span>
                    </a>
                </li>
                <li>
                    <a class="nav-link" href="logout">
                        <span class="dz-icon">
                            <i class="fas fa-key"></i>
                        </span>
                        <span>Logout</span>
                    </a>
                </li>
            </ul>
            <div class="sidebar-bottom">
                <ul class="app-setting">
                    <li class="nav-color pb-2">
                        <a href="javascript:void(0);" data-bs-toggle="offcanvas" data-bs-target="#offcanvasBottom"
                            aria-controls="offcanvasBottom">
                            <span class="dz-icon">
                                <svg class="color-plate" width="20" height="20" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                        d="M10.725.787a9.325 9.325 0 0 1 	8.425 7.65 2.35 2.35 0 0 1-.625 2.275 1.662 1.662 0 0 1-1.863.188c-.462-.225-.812-.6-1.25-.788a4.238 4.238 0 0 0-4.5.725A3.751 3.751 0 0 0 10 14.825c.237.725.75 1.25 1.012 1.987a1.713 1.713 0 0 1-.762 2.063 3.312 3.312 0 0 1-2.5.125A9.262 9.262 0 0 1 3.125 3.837a9.2 9.2 0 0 1 7.6-3.05zM2.162 11.6A8.112 8.112 0 0 0 8 17.85c.487.125 1.25.3 1.6 0 .35-.3.15-.9-.125-1.25a4.674 4.674 0 0 1-.725-1.388A5 5 0 0 1 10 9.925a5.187 5.187 0 0 1 3.6-1.4 5.063 5.063 0 0 1 3.137 1.025.887.887 0 0 0 .95.225c.4-.213.338-.75.263-1.125a8.413 8.413 0 0 0-1.963-3.95 8.087 8.087 0 0 0-11.937 0 8.075 8.075 0 0 0-1.9 6.9h.012z" />
                                    <path
                                        d="M14.313 4.862a1.575 1.575 0 1 1 .024 3.15 1.575 1.575 0 0 1-.024-3.15zm0 2.2a.637.637 0 1 0 0-1.274.637.637 0 0 0 0 1.274zm-4.075-4.075a1.575 1.575 0 1 1 0 3.15 1.575 1.575 0 0 1 0-3.15zm0 2.2a.637.637 0 1 0 0-1.274.637.637 0 0 0 0 1.274zM6.25 7.925a1.575 1.575 0 1 1 .025-3.15 1.575 1.575 0 0 1-.025 3.15zm0-2.2A.637.637 0 1 0 6.25 7a.637.637 0 0 0 0-1.275zm.125 4.675a1.575 1.575 0 1 1-3.15 0 1.575 1.575 0 0 1 3.15 0zm-2.2 0a.638.638 0 1 0 1.275 0 .638.638 0 0 0-1.275 0zm2.075 2.387a1.575 1.575 0 1 1 0 3.151 1.575 1.575 0 0 1 0-3.15zm0 2.213a.638.638 0 1 0 0-1.276.638.638 0 0 0 0 1.276z" />
                                </svg>
                            </span>
                            <span>Color Theme</span>
                            <div class="color-active ms-auto">
                                <span>Active</span>
                                <div class="current-color"></div>
                            </div>
                        </a>
                    </li>
                    <li>
                        <a class="mode" href="javascript:void(0);">
                            <span class="dz-icon">
                                <i class="fas fa-moon"></i>
                            </span>
                            <span>Dark Mode</span>
                            <div class="custom-switch">
                                <input type="checkbox" class="switch-input theme-btn" id="toggle-dark-menu">
                                <label class="custom-switch-label" for="toggle-dark-menu"></label>
                            </div>
                        </a>
                    </li>
                </ul>
                <div class="app-info">
                    <h6 class="name">W3Cart Fashion Store</h6>
                    <span class="ver-info">App Version 1.0</span>
                </div>
            </div>
        </div>
        <!-- Sidebar End -->
        <br><br>
        <!-- Page Content Start -->
        <div class="page-content space-top p-b80">
            <div class="container">
                <!-- Banner -->
                <div class="dz-banner">
                    <div class="swiper banner-swiper">
                        <div class="swiper-wrapper">
                            <div class="swiper-slide">
                                <div class="banner-bg"
                                    style="background-image: url('public/assets/images/banner/pic1.png');">
                                </div>
                                <div class="banner-content">
                                    <span class="font-w500">#SMART TRADE</span>
                                    <h2 class="offer">OVER7% RETURN</h2>
                                    <p>Discover our top Products</p>
                                    <a href="vip" class="btn btn-primary btn-sm">Order Now</a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="banner-bg"
                                    style="background-image: url('public/assets/images/banner/pic2.png');">
                                </div>
                                <div class="banner-content content-right">
                                    <span class="font-w500">#GO BIG TODAY</span>
                                    <h2 class="offer">Instant Transactions% </h2>
                                    <p>Discover our latest Products</p>
                                    <a href="deposit" class="btn btn-primary btn-sm">Recharge</a>
                                </div>
                            </div>
                            <div class="swiper-slide">
                                <div class="banner-bg"
                                    style="background-image: url('public/assets/images/banner/pic3.png');">
                                </div>
                                <div class="banner-content">
                                    <span class="font-w500">#INVITE TO EARN</span>
                                    <h2 class="offer">10% BONUS</h2>
                                    <p>Invite to start earning</p>
                                    <a href="downlines" class="btn btn-primary btn-sm">MY TEAM</a>
                                </div>
                            </div>
                        </div>
                        <div class="swiper-pagination style-2"></div>
                    </div>
                </div>
                <!-- Banner End -->
                <div class="title-bar container mb-0 pb-0">
                    <h5 class="title font-w800 mb-0">Totals Overview</h5>
                    <a href="deposit">Add more</a>
                </div>

                <!-- Shop Section Strat -->
                <div class="row g-4 justify-content-around">
                    <div class="col-5 col-lg-6 shadow rounded bg-info">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4 p-sm-8">
                                <h4 class="stats-type mb-1">Balance</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format(Auth::user()->balance, 2)); ?>

                                </div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->

                    <div class="col-5 col-lg-6 shadow rounded bg-success">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1 text-white">Returns</h4>
                                <div class="stats-figure">KES.<?php echo e(number_format($daily, 2)); ?></div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->






                    <div class="col-5 col-lg-6 shadow bg-primary rounded">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1">Products</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format($inv, 2)); ?></div>
                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->
                    <div class="col-5 col-lg-6 shadow bg-secondary rounded">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1 text-white">Cashouts</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format($cashout, 2)); ?></div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->
                </div>
                <!-- Shop Section End -->

                <div class="title-bar container my-0">
                    <h5 class="title font-w800 mb-0">Top Products </h5>
                    <a href="product">See more</a>
                </div>

                <!-- Shop Section Start -->
                <div class="swiper trending-swiper p-lr15">
                    <div class="swiper-wrapper">
                        <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="swiper-slide">
                            <div class="shop-card style-2">
                                <div class="dz-media">
                                    <a href="package?p=<?php echo e($p->id); ?>">
                                        <img src="public/products/smart.png" alt="image">
                                    </a>
                                    <div class="product-tag">
                                        <span class="review me-2"><i
                                                class="fa-solid fa-star"></i><?php echo e($p->days); ?>Days</span>
                                        <span class="total">ST-<?php echo e($p->id); ?></span>
                                    </div>
                                </div>
                                <div class="dz-content">
                                    <span class="font-12">Total :<?php echo e($p->daily_income * $p->days); ?></span>
                                    <h6 class="title"><a href="package?p=<?php echo e($p->id); ?>"><?php echo e($p->vip); ?></a></h6>
                                    <h6 class="price">KES.<?php echo e($p->price); ?></h6>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
                <!-- Shop Section End -->
            </div>
        </div>
        <!-- Page Content End -->

        <!-- Menubar -->
        <div class="menubar-area footer-fixed rounded-0">
            <div class="toolbar-inner menubar-nav">
                <a href="home" class="nav-link active">
                    <i class="fas fa-home"></i>
                    <span>Home</span>
                </a>
                <a href="vip" class="nav-link">
                    <i class="fas fa-tag"></i>
                    <span>Products</span>
                </a>
                <a href="vip" class="nav-link cart-handle">
                    <div class="hexad-menu">
                        <img src="public/assets/images/4.svg" class="shape-dark" alt="">
                        <img src="public/assets/images/4.svg" class="shape-light" alt="">
                        <i class="fas fa-shopping-bag"></i>
                    </div>
                </a>
                <a href="deposit" class="nav-link">
                    <i class="fas fa-heart"></i>
                    <span>Deposit</span>
                </a>
                <a href="profile" class="nav-link">
                    <i class="fas fa-user"></i>
                    <span>Profile</span>
                </a>
            </div>
        </div>
        <!-- Menubar -->
      

    </div>
    <!--**********************************
    Scripts
***********************************-->
    <script src="public/assets/js/jquery.js"></script>
    <script src="public/assets/vendor/bootstrap/js/bootstrap.bundle.min.js"></script>
    <script src="public/assets/vendor/swiper/swiper-bundle.min.js"></script><!-- Swiper -->
    <script
        src="https://w3cart.dexignzone.com/xhtml/assets/vendor/bootstrap-touchspin/dist/jquery.bootstrap-touchspin.min.js"></script>
    <!-- Swiper -->
    <script src="public/assets/js/dz.carousel.js"></script><!-- Swiper -->
    <script src="public/assets/js/settings.js"></script>
    <script src="public/assets/js/custom.js"></script>
    <script src="public/index.js"></script>
</body>

</html><?php /**PATH /home/uniquesq/smartcentral.com.ng/resources/views/user/dashboard.blade.php ENDPATH**/ ?>