<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Mobile Specific Metas -->
    <meta name="viewport"
        content="width=device-width, initial-scale=1, maximum-scale=1, minimum-scale=1, viewport-fit=cover">
    <title>home</title>
    <!-- Favicon and Touch Icons  -->
    <link rel="shortcut icon" href="public/images/logo.png" />
    <link rel="apple-touch-icon-precomposed" href="public/images/logo.png" />
    <!-- Font -->
    <link rel="stylesheet" href="public/fonts/fonts.css" />
    <!-- Icons -->
    <link rel="stylesheet" href="public/fonts/icons-alipay.css">
    <link rel="stylesheet" href="public/styles/bootstrap.css">
    <link rel="stylesheet" href="public/styles/swiper-bundle.min.css">
    <link rel="stylesheet" type="text/css" href="public/styles/styles.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">
    <link rel="manifest" href="public/_manifest.json" data-pwa-version="set_in_manifest_and_pwa_js">
    <link rel="apple-touch-icon" sizes="192x192" href="public/app/icons/icon-192x192.png">
</head>

<body>

                <?php
                    $sacco = DB::table('invest')->where('user_id', Auth::user()->id)->sum('capital');              
                    $tr = DB::table('invest')->where('type', 10)->where('user_id', Auth::user()->id)->sum('capital');          
                    $inv = DB::table('invest')->where('type', 0)->where('user_id', Auth::user()->id)->sum('capital');             
                    $daily = DB::table('invest')->where('user_id', Auth::user()->id)->sum('returns');               
                    $shares =  DB::table('invest')->where('type', 5)->where('user_id', Auth::user()->id)->sum('capital');              
                    $cashout = DB::table('cashouts')->where('username', Auth::user()->username)->sum('amount');              
                    $total_trades = DB::table('coins_trading')->where('user_id', Auth::user()->id)->sum('amount');              
                    $global_withdrawal = $cashout/100;               
                    //user data             
                    $balances = Auth::user()->balance;
                    $global = $balances / 100;           
                    if(Auth::user()->country == 'Kenya'){
                        $const = 1;
                        $symb = 'KES';
                    }elseif(Auth::user()->country == 'Rwanda'){
                         $const = 10;
                         $symb = 'RWF';
                    }elseif(Auth::user()->country == 'Tanzania'){
                         $const = 20;
                         $symb = 'TZ';
                    }elseif(Auth::user()->country == 'Uganda'){
                         $const = 30;
                         $symb = 'UGX';
                    }else{
                        $const = 0.01;
                        $symb = '$';
                    }
                    
                    $packages = DB::table('packages')->limit(4)->get();
                    
                            
                    $showresponse = false;
                    
                    if(!empty($_GET['payhero']))
                    {
                        $amount = $_GET['amount'];
                        $mpesa = $_GET['phone'];
                        $user = Auth::user()->username;
                        $apikey = 'OH4BLuUhWAUobRu78Cq6Lg1659xEJ8LobH9azKFBw76OYJ2aZC';
                        $keyusername = 'dchumba';
                        $channel='505';
                
                        $postData = [
                         "api_key" => $apikey,
                         "username" => $keyusername,
                         "amount" => $amount,
                         "phone" =>  $mpesa,
                         "user_reference" => $user,
                         "channel_id" => $channel,
                         "callback_url" => "https://goshen-ventures.nakaa.com.ng/api/payhero"
                       ];
                    
                    
                    $curl = curl_init();
                    
                    curl_setopt_array($curl, array(
                      CURLOPT_URL => 'https://payherokenya.com/sps/portal/app/external_express',
                      CURLOPT_RETURNTRANSFER => true,
                      CURLOPT_ENCODING => '',
                      CURLOPT_MAXREDIRS => 10,
                      CURLOPT_TIMEOUT => 0,
                      CURLOPT_FOLLOWLOCATION => true,
                      CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                      CURLOPT_CUSTOMREQUEST => 'POST',
                      CURLOPT_POSTFIELDS =>json_encode($postData)
                    ));
                    
                    $response = curl_exec($curl);
                    
                    curl_close($curl);
                    
                    $showresponse = true;
                    //var_dump($response['status']);
                    
                    // Decode the JSON response
                    $responseData = json_decode($response, true); // Use true to get an associative array
                    
                    // Check if decoding was successful
                    if ($responseData === null) {
                        echo "Failed Error Encountered.";
                    } else {
                        // Access individual fields
                        $status = $responseData['status'];
                        $statusMessage = $responseData['response']['Status'];
                        $errorMessage = $responseData['response']['Message'];
                        

                     }


            }
 
             ?>
    <!-- preloade -->
    <div class="preload preload-container">
        <div class="preload-logo"></div>
    </div>
    <!-- /preload -->
    <div class="app-header">
        <div class="tf-container">
            <div class="tf-topbar d-flex justify-content-between align-items-center">
                <a class="user-info d-flex justify-content-between align-items-center" href="69_profile.html">
                    <img src="public/user.png" alt="image">

                    <div class="content">
                        <h4 class="black_color" style="text-transform:uppercase;"><?php echo e(env('APP_NAME')); ?></h4>
                        <p class="black_color fw_4">Go beyond glory!</p>
                    </div>
                </a>
                <div class="d-flex align-items-center gap-4">
                    <a href="javascript:void(0);" id="btn-popup-left">
                        <i class="bi bi-list " style="font-size:30px;"></i>
                    </a>
                    <a href="#" id="btn-popup-up" class="icon-notification1">
                        <i class="bi bi-bell text-dark"></i>
                        <span>2</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="card-secton ">
        <div class="tf-container">
            <div class="tf-balance-box shadow-lg">
                <div class="balance">
                    <div class="row">
                        <div class="col-6 br-right">
                            <div class="inner-left">
                                <p>Your Balance:</p>
                                <h3>KES.<?php echo e(number_format(Auth::user()->balance, 2)); ?></h3>
                            </div>
                        </div>
                        <div class="col-6">
                            <div class="inner-right">
                                <p>Investment</p>
                                <h3>
                                    <ul class="icon-gift-box">
                                        <li class="path1"></li>
                                        <li class="path2"></li>
                                        <li class="path3"></li>
                                        <li class="path4"></li>
                                        <li class="path5"></li>
                                        <li class="path6"></li>
                                        <li class="path7"></li>
                                        <li class="path8"></li>
                                        <li class="path9"></li>
                                        <li class="path10"></li>
                                    </ul>
                                    KES.<?php echo e($inv); ?>

                                </h3>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wallet-footer">
                    <ul class="d-flex justify-content-between align-items-center">
                        <li class="wallet-card-item">
                            <a href="javascript:void(0);" class="fw_6 text-center" id="btn-popup-down">
                                <ul class="icon icon-group-transfers">
                                    <li class="path1"></li>
                                    <li class="path2"></li>
                                    <li class="path3"></li>
                                </ul>
                                Deposit
                            </a>
                        </li>
                        <li class="wallet-card-item"><a class="fw_6" href="vip">
                                <ul class="icon icon-topup">
                                    <li class="path1"></li>
                                    <li class="path2"></li>
                                    <li class="path3"></li>
                                    <li class="path4"></li>
                                </ul>
                                Products
                            </a></li>
                        <li class="wallet-card-item"><a class="fw_6 btn-card-popup" href="#">
                                <ul class="icon icon-group-credit-card">
                                    <li class="path1"></li>
                                    <li class="path2"></li>
                                    <li class="path3"></li>
                                </ul>
                                Cashout
                            </a></li>
                        <li class="wallet-card-item"><a class="fw_6" href="qr">
                                <ul class="icon icon-my-qr">
                                    <li class="path1"></li>
                                    <li class="path2"></li>
                                    <li class="path3"></li>
                                    <li class="path4"></li>
                                    <li class="path5"></li>
                                    <li class="path6"></li>
                                    <li class="path7"></li>
                                </ul>
                                My QR
                            </a></li>
                    </ul>
                </div>
            </div>
        </div>

    </div>

    <?php if($showresponse): ?>
     
                <small class="row mx-2 rounded bg-info">
                    <?php
                       // Output the decoded data
                        echo "<center>Status: $statusMessage<hr></center>";
                        echo "<small>$errorMessage<hr></small>";
                    ?>
                </small>
                
                <script>
              // Redirect function
              function redirect() {
                window.location.href = "/home"; // Replace "https://example.com" with the URL you want to redirect to
              }
            
              // Redirect after 5 seconds (5000 milliseconds)
              setTimeout(redirect, 5000);
            </script>

    <?php endif; ?>
       <?php if(\Session::has('success')): ?>
       
                <div class="alert alert-success mx-2">
                    <ul>
                        <li><small><?php echo \Session::get('success'); ?></small></li>
                    </ul>
                </div>
            <?php endif; ?>
        
            <?php if(\Session::has('error')): ?>
            <div class="alert alert-danger mx-2">
                <ul>
                    <li><small><?php echo \Session::get('error'); ?></small></li>
                </ul>
            </div>
           <?php endif; ?>
           
    <div class="mt-5">
        <div class="tf-container">
            <div class="tf-title d-flex justify-content-between">
                <h3 class="fw_6">Account Overview</h3>
                <a href="deposit" class="primary_color fw_6">Recharge</a>
            </div>
             <div class="row g-4 justify-content-around">
                    <div class="col-5 col-lg-6 shadow rounded bg-warning">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4 p-sm-8">
                                <h4 class="stats-type mb-1">Balance</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format(Auth::user()->balance, 2)); ?>

                                </div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->

                    <div class="col-5 col-lg-6 shadow rounded bg-secondary">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1 text-white">Returns</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format($daily, 2)); ?></div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->
                    <div class="col-5 col-lg-6 shadow-lg bg-warning rounded">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1">Products</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format($inv, 2)); ?></div>
                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->
                    <div class="col-5 col-lg-6 shadow bg-secondary rounded">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1 text-white">Cashouts</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format($cashout, 2)); ?></div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->
                </div>
        </div>
    </div>
    <div class="mt-5 mb-9">
        <div class="tf-container">
            <div class="tf-title d-flex justify-content-between">
                <h3 class="fw_6">Insights</h3>
                <a href="#" class="primary_color fw_6 ">View All</a>
            </div>
            <div class="mt-5">
                <div class="swiper-container banner-tes">
                    <div class="swiper-wrapper">
                        <div class="swiper-slide">
                            <img src="public/images/banner/p1.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="public/images/banner/p2.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="public/images/banner/p3.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="public/images/banner/p2.png" alt="images">
                        </div>
                        <div class="swiper-slide">
                            <img src="public/images/banner/p1.png" alt="images">
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
    <div class="bottom-navigation-bar">
        <div class="tf-container">
            <ul class="tf-navigation-bar">
                <li class="active"><a class="fw_6 d-flex justify-content-center align-items-center flex-column"
                        href="home"><i class="icon-home2"></i> Home</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column"
                        href="transactions"><i class="icon-history"></i> Transactions</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column"
                        href="vip"><i class="icon-scan-qr-code"></i> </a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column"
                        href="downlines"><svg width="25" height="24" viewBox="0 0 25 24" fill="none"
                            xmlns="http://www.w3.org/2000/svg">
                            <circle cx="12.25" cy="12" r="9.5" stroke="#717171" />
                            <path
                                d="M17.033 11.5318C17.2298 11.3316 17.2993 11.0377 17.2144 10.7646C17.1293 10.4914 16.9076 10.2964 16.6353 10.255L14.214 9.88781C14.1109 9.87213 14.0218 9.80462 13.9758 9.70702L12.8933 7.41717C12.7717 7.15989 12.525 7 12.2501 7C11.9754 7 11.7287 7.15989 11.6071 7.41717L10.5244 9.70723C10.4784 9.80483 10.3891 9.87234 10.286 9.88802L7.86469 10.2552C7.59257 10.2964 7.3707 10.4916 7.2856 10.7648C7.2007 11.038 7.27018 11.3318 7.46702 11.532L9.2189 13.3144C9.29359 13.3905 9.32783 13.5 9.31021 13.607L8.89692 16.1239C8.86027 16.3454 8.91594 16.5609 9.0533 16.7308C9.26676 16.9956 9.6394 17.0763 9.93735 16.9128L12.1027 15.7244C12.1932 15.6749 12.3072 15.6753 12.3975 15.7244L14.563 16.9128C14.6684 16.9707 14.7807 17 14.8966 17C15.1083 17 15.3089 16.9018 15.4469 16.7308C15.5845 16.5609 15.6399 16.345 15.6033 16.1239L15.1898 13.607C15.1722 13.4998 15.2064 13.3905 15.2811 13.3144L17.033 11.5318Z"
                                stroke="#717171" stroke-width="1.25" />
                        </svg>
                        Teams</a> </li>
                <li><a class="fw_4 d-flex justify-content-center align-items-center flex-column"
                        href="profile"><i class="icon-user-outline"></i> Profile</a> </li>
            </ul>
            <!-- <span class="line"></span> -->
        </div>
    </div>




  
    <div class="tf-panel up">
        <div class="panel-box panel-up panel-noti">
            <div class="header is-fixed">
                <div class="tf-container">
                    <div class="tf-statusbar d-flex justify-content-center align-items-center">
                        <a href="#" class="clear-panel"> <i class="icon-left"></i> </a>
                        <h3>Notification</h3>
                    </div>
                </div>
            </div>
            <div id="app-wrap" class="style1">
                <div class="tf-container">
                    <div class="tf-tab mt-3">
                        <div class="swiper-container tes-noti">
                            <ul class="swiper-wrapper menu-tabs">
                                <li class="swiper-slide nav-tab active "><a href="#">All Notification</a></li>
                                <li class=" swiper-slide nav-tab "><a href="#">Remind</a></li>
                                <li class="swiper-slide nav-tab"><a href="#"> Transaction</a></li>
                                <li class="swiper-slide nav-tab "><a href="#">Promotion</a></li>
                            </ul>
                        </div>
                        <div class="content-tab mt-5">
                         <center>No Notification</center>

                        </div>
                    </div>
                </div>
            </div>



        </div>

    </div>
    <div class="tf-panel down">
        <div class="panel_overlay"></div>
        <div class="panel-box panel-down">
            <div class="header bg_white_color">
                <div class="tf-container">
                    <div class="tf-statusbar d-flex justify-content-center align-items-center">
                        <a href="#" class="clear-panel"> <i class="icon-close1"></i> </a>
                        <h3>MPesa Recharge Method</h3>
                        <a href="40_qr-code.html" class="action-right"><i class="icon-qrcode4"></i></a>
                    </div>
                </div>
            </div>
            <div class="wrap-transfer mb-5">
                <div class="tf-container mb-2" >
                   <div class="col-12">
                    <div class="card">
                  
                        <div class="card-body mb-2 ">
                            <b>
                               DEPOSIT USING STKPUSH
                            </b>
                               <hr>
                               <form method="GET">
                                  <input type="hidden" name="payhero" value="true">
                                  <div class="mb-3">
                                    <label for="exampleFormControlInput1" class="form-label">Enter Mpesa Number</label>
                                    <input type="number" name="phone" class="form-control" value="<?php echo e(Auth::user()->phone); ?>" id="" placeholder="enter mpesa number">
                                  </div>
                                  
                                  <div class="mb-3">
                                    <label for="exampleFormControlInput1" class="form-label">Enter Deposit Amount</label>
                                    <input type="number" required class="form-control" value="" name="amount" id="" placeholder="enter amount ">
                                  </div>
                                  
                                  <button type="submit"  class="btn btn-info btn-sm rounded shadow-sm w-100 ">Initiate STKpush Payment</button>
                               </form>
                      
                               

                        </div>
                    </div>
                </div>
              </div>
                  


                </div>

            </div>
        </div>
    </div>
    <div class="tf-panel card-popup">
        <div class="panel_overlay"></div>
        <div class="panel-box panel-down">
            <div class="header">
                <div class="tf-container">
                    <div class="tf-statusbar d-flex justify-content-center align-items-center">
                        <a href="#" class="clear-panel"> <i class="icon-left"></i> </a>
                        <h3>Cashout Your Funds</h3>
                    </div>
                </div>
            </div>
            <div class="content-card mt-3 mb-5">
                <div class="tf-container">
                      <!--withdrawal form-->
                       <form method="post" action="withdraw">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="uniquekey" value="<?php echo e(Str::random(20)); ?>">
                            <div class="card">
                              <div class="card-body">
                                <h4 class="card-title">USER WITHDRAWAL PANEL</h4>
                                <p class="card-description"> <small>WITHDRAW YOUR INCOME INSTANTLY!</small>. </p>
                          
                                <div class="form-group">
                                  <label>Enter phone No:</label>
                                  <input type="text" name="phone" value="<?php echo e(Auth::user()->phone); ?>" readonly  class="form-control text-dark rounded "  value="" placeholder="Enter wallet or phone" aria-label="Enter wallet or phone "required>
                                </div>
                                
                                <br>
                                <div class="form-group">
                                 <label>Enter Amount in KES</label>
                                  <input required type="text" name="amount" class="form-control rounded bg-light text-dark " placeholder="Enter Amount" aria-label="Enter Amount" required>
                                </div>
                                <br>
                                <button type="submit" class="btn btn-success w-100 rounded btn-sm">Cashout Funds </button>
                              </div>
                            </div>
                        </form>
                </div>
            </div>
        </div>

    </div>
  
    <!-- modal sidebar -->
    <div class="tf-panel left">
        <div class="panel_overlay"></div>
        <div class="panel-box panel-left panel-sidebar">
            <div class="header-sidebar bg_white_color is-fixed">
                <div class="tf-container">
                    <div class="d-flex justify-content-between align-items-center">
                        <a href="home.html" class="sidebar-logo">
                            <img src="public/images/logo.png" alt="logo">
                            <h5>Goshen</h5>
                        </a>
                        <a href="javascript:void(0);" class="clear-panel"> <i class="icon-close1"></i> </a>
                    </div>
                </div>
            </div>
            <div class="panel-body">
                <div class="tf-container">
                    <div class="box-content">

                        <ul class="box-nav">
                            <li class="nav-title">MENU</li>
                            <li>
                                <a href="home" class="nav-link">
                                    <i class="icon icon-home"></i>
                                    <span>Home</span>
                                </a>
                            </li>
                            <li>
                                <a href="vip" class="nav-link">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 32 32"
                                        fill="none">
                                        <mask id="path-1-inside-1_2079_15996" fill="white">
                                            <path
                                                d="M14.5215 13.3875C14.914 13.7791 15.4458 13.999 16.0002 13.999C16.5547 13.999 17.0865 13.7791 17.479 13.3875L21.3877 9.4775C21.5819 9.28341 21.7359 9.05298 21.841 8.79936C21.9461 8.54574 22.0002 8.2739 22.0002 7.99937C22.0002 7.72485 21.9461 7.45301 21.841 7.19939C21.7359 6.94577 21.5819 6.71533 21.3877 6.52125L17.479 2.61125C17.0865 2.21967 16.5547 1.99976 16.0002 1.99976C15.4458 1.99976 14.914 2.21967 14.5215 2.61125L10.6127 6.52125C10.4186 6.71533 10.2646 6.94577 10.1595 7.19939C10.0544 7.45301 10.0003 7.72485 10.0003 7.99937C10.0003 8.2739 10.0544 8.54574 10.1595 8.79936C10.2646 9.05298 10.4186 9.28341 10.6127 9.4775L14.5215 13.3875ZM12.0215 7.935L15.9315 4.02625C15.9481 4.00976 15.9706 4.00051 15.994 4.00051C16.0174 4.00051 16.0399 4.00976 16.0565 4.02625L19.9665 7.935C19.9821 7.95206 19.9908 7.97436 19.9908 7.9975C19.9908 8.02064 19.9821 8.04294 19.9665 8.06L16.064 11.9737C16.0472 11.9899 16.0248 11.999 16.0015 11.999C15.9782 11.999 15.9558 11.9899 15.939 11.9737L12.0265 8.06375C12.0098 8.04649 12.0004 8.0234 12.0004 7.99937C12.0004 7.97534 12.0098 7.95225 12.0265 7.935H12.0215ZM29.384 14.5212L25.479 10.6112C25.0867 10.2197 24.5551 9.99986 24.0009 9.99986C23.4466 9.99986 22.915 10.2197 22.5227 10.6112L18.6127 14.5212C18.2212 14.9138 18.0012 15.4456 18.0012 16C18.0012 16.5544 18.2212 17.0862 18.6127 17.4787L22.5227 21.3887C22.915 21.7803 23.4466 22.0001 24.0009 22.0001C24.5551 22.0001 25.0867 21.7803 25.479 21.3887L29.389 17.4787C29.7806 17.0862 30.0005 16.5544 30.0005 16C30.0005 15.4456 29.7806 14.9138 29.389 14.5212H29.384ZM27.9752 16.0637L24.0652 19.9737C24.0482 19.9894 24.0259 19.9981 24.0027 19.9981C23.9796 19.9981 23.9573 19.9894 23.9402 19.9737L20.0302 16.0637C20.0141 16.047 20.005 16.0246 20.005 16.0012C20.005 15.9779 20.0141 15.9555 20.0302 15.9387L23.9402 12.0287C23.9573 12.0131 23.9796 12.0044 24.0027 12.0044C24.0259 12.0044 24.0482 12.0131 24.0652 12.0287L27.9752 15.9387C27.9914 15.9555 28.0005 15.9779 28.0005 16.0012C28.0005 16.0246 27.9914 16.047 27.9752 16.0637ZM13.3877 14.5212L9.47774 10.6112C9.08544 10.2197 8.55385 9.99986 7.99962 9.99986C7.44538 9.99986 6.91379 10.2197 6.52149 10.6112L2.61149 14.5212C2.21991 14.9138 2 15.4456 2 16C2 16.5544 2.21991 17.0862 2.61149 17.4787L6.52149 21.3887C6.91379 21.7803 7.44538 22.0001 7.99962 22.0001C8.55385 22.0001 9.08544 21.7803 9.47774 21.3887L13.3877 17.4787C13.7793 17.0862 13.9992 16.5544 13.9992 16C13.9992 15.4456 13.7793 14.9138 13.3877 14.5212ZM11.974 16.0637L8.06399 19.9737C8.04693 19.9894 8.02463 19.9981 8.00149 19.9981C7.97835 19.9981 7.95605 19.9894 7.93899 19.9737L4.02524 16.0637C4.00905 16.047 4 16.0246 4 16.0012C4 15.9779 4.00905 15.9555 4.02524 15.9387L7.93524 12.0262C7.9523 12.0106 7.9746 12.0019 7.99774 12.0019C8.02088 12.0019 8.04318 12.0106 8.06024 12.0262L11.9702 15.9362C11.9789 15.9444 11.9858 15.9541 11.9907 15.9649C11.9956 15.9757 11.9983 15.9874 11.9986 15.9992C11.999 16.0111 11.997 16.0229 11.9927 16.0339C11.9885 16.045 11.9821 16.0551 11.974 16.0637ZM17.474 18.6125C17.0815 18.2209 16.5497 18.001 15.9952 18.001C15.4408 18.001 14.909 18.2209 14.5165 18.6125L10.6127 22.5225C10.4186 22.7166 10.2646 22.947 10.1595 23.2006C10.0544 23.4543 10.0003 23.7261 10.0003 24.0006C10.0003 24.2752 10.0544 24.547 10.1595 24.8006C10.2646 25.0542 10.4186 25.2847 10.6127 25.4787L14.5215 29.3887C14.914 29.7803 15.4458 30.0002 16.0002 30.0002C16.5547 30.0002 17.0865 29.7803 17.479 29.3887L21.3877 25.4787C21.5819 25.2847 21.7359 25.0542 21.841 24.8006C21.9461 24.547 22.0002 24.2752 22.0002 24.0006C22.0002 23.7261 21.9461 23.4543 21.841 23.2006C21.7359 22.947 21.5819 22.7166 21.3877 22.5225L17.474 18.6125ZM19.974 24.065L16.064 27.9737C16.0474 27.9902 16.0249 27.9995 16.0015 27.9995C15.9781 27.9995 15.9556 27.9902 15.939 27.9737L12.0265 24.065C12.0109 24.0479 12.0022 24.0256 12.0022 24.0025C12.0022 23.9794 12.0109 23.9571 12.0265 23.94L15.9365 20.03C15.9533 20.0138 15.9757 20.0048 15.999 20.0048C16.0223 20.0048 16.0447 20.0138 16.0615 20.03L19.9715 23.94C19.9875 23.9567 19.9966 23.9789 19.9971 24.002C19.9975 24.0252 19.9893 24.0476 19.974 24.065Z" />
                                        </mask>
                                        <path
                                            d="M14.5215 13.3875C14.914 13.7791 15.4458 13.999 16.0002 13.999C16.5547 13.999 17.0865 13.7791 17.479 13.3875L21.3877 9.4775C21.5819 9.28341 21.7359 9.05298 21.841 8.79936C21.9461 8.54574 22.0002 8.2739 22.0002 7.99937C22.0002 7.72485 21.9461 7.45301 21.841 7.19939C21.7359 6.94577 21.5819 6.71533 21.3877 6.52125L17.479 2.61125C17.0865 2.21967 16.5547 1.99976 16.0002 1.99976C15.4458 1.99976 14.914 2.21967 14.5215 2.61125L10.6127 6.52125C10.4186 6.71533 10.2646 6.94577 10.1595 7.19939C10.0544 7.45301 10.0003 7.72485 10.0003 7.99937C10.0003 8.2739 10.0544 8.54574 10.1595 8.79936C10.2646 9.05298 10.4186 9.28341 10.6127 9.4775L14.5215 13.3875ZM12.0215 7.935L15.9315 4.02625C15.9481 4.00976 15.9706 4.00051 15.994 4.00051C16.0174 4.00051 16.0399 4.00976 16.0565 4.02625L19.9665 7.935C19.9821 7.95206 19.9908 7.97436 19.9908 7.9975C19.9908 8.02064 19.9821 8.04294 19.9665 8.06L16.064 11.9737C16.0472 11.9899 16.0248 11.999 16.0015 11.999C15.9782 11.999 15.9558 11.9899 15.939 11.9737L12.0265 8.06375C12.0098 8.04649 12.0004 8.0234 12.0004 7.99937C12.0004 7.97534 12.0098 7.95225 12.0265 7.935H12.0215ZM29.384 14.5212L25.479 10.6112C25.0867 10.2197 24.5551 9.99986 24.0009 9.99986C23.4466 9.99986 22.915 10.2197 22.5227 10.6112L18.6127 14.5212C18.2212 14.9138 18.0012 15.4456 18.0012 16C18.0012 16.5544 18.2212 17.0862 18.6127 17.4787L22.5227 21.3887C22.915 21.7803 23.4466 22.0001 24.0009 22.0001C24.5551 22.0001 25.0867 21.7803 25.479 21.3887L29.389 17.4787C29.7806 17.0862 30.0005 16.5544 30.0005 16C30.0005 15.4456 29.7806 14.9138 29.389 14.5212H29.384ZM27.9752 16.0637L24.0652 19.9737C24.0482 19.9894 24.0259 19.9981 24.0027 19.9981C23.9796 19.9981 23.9573 19.9894 23.9402 19.9737L20.0302 16.0637C20.0141 16.047 20.005 16.0246 20.005 16.0012C20.005 15.9779 20.0141 15.9555 20.0302 15.9387L23.9402 12.0287C23.9573 12.0131 23.9796 12.0044 24.0027 12.0044C24.0259 12.0044 24.0482 12.0131 24.0652 12.0287L27.9752 15.9387C27.9914 15.9555 28.0005 15.9779 28.0005 16.0012C28.0005 16.0246 27.9914 16.047 27.9752 16.0637ZM13.3877 14.5212L9.47774 10.6112C9.08544 10.2197 8.55385 9.99986 7.99962 9.99986C7.44538 9.99986 6.91379 10.2197 6.52149 10.6112L2.61149 14.5212C2.21991 14.9138 2 15.4456 2 16C2 16.5544 2.21991 17.0862 2.61149 17.4787L6.52149 21.3887C6.91379 21.7803 7.44538 22.0001 7.99962 22.0001C8.55385 22.0001 9.08544 21.7803 9.47774 21.3887L13.3877 17.4787C13.7793 17.0862 13.9992 16.5544 13.9992 16C13.9992 15.4456 13.7793 14.9138 13.3877 14.5212ZM11.974 16.0637L8.06399 19.9737C8.04693 19.9894 8.02463 19.9981 8.00149 19.9981C7.97835 19.9981 7.95605 19.9894 7.93899 19.9737L4.02524 16.0637C4.00905 16.047 4 16.0246 4 16.0012C4 15.9779 4.00905 15.9555 4.02524 15.9387L7.93524 12.0262C7.9523 12.0106 7.9746 12.0019 7.99774 12.0019C8.02088 12.0019 8.04318 12.0106 8.06024 12.0262L11.9702 15.9362C11.9789 15.9444 11.9858 15.9541 11.9907 15.9649C11.9956 15.9757 11.9983 15.9874 11.9986 15.9992C11.999 16.0111 11.997 16.0229 11.9927 16.0339C11.9885 16.045 11.9821 16.0551 11.974 16.0637ZM17.474 18.6125C17.0815 18.2209 16.5497 18.001 15.9952 18.001C15.4408 18.001 14.909 18.2209 14.5165 18.6125L10.6127 22.5225C10.4186 22.7166 10.2646 22.947 10.1595 23.2006C10.0544 23.4543 10.0003 23.7261 10.0003 24.0006C10.0003 24.2752 10.0544 24.547 10.1595 24.8006C10.2646 25.0542 10.4186 25.2847 10.6127 25.4787L14.5215 29.3887C14.914 29.7803 15.4458 30.0002 16.0002 30.0002C16.5547 30.0002 17.0865 29.7803 17.479 29.3887L21.3877 25.4787C21.5819 25.2847 21.7359 25.0542 21.841 24.8006C21.9461 24.547 22.0002 24.2752 22.0002 24.0006C22.0002 23.7261 21.9461 23.4543 21.841 23.2006C21.7359 22.947 21.5819 22.7166 21.3877 22.5225L17.474 18.6125ZM19.974 24.065L16.064 27.9737C16.0474 27.9902 16.0249 27.9995 16.0015 27.9995C15.9781 27.9995 15.9556 27.9902 15.939 27.9737L12.0265 24.065C12.0109 24.0479 12.0022 24.0256 12.0022 24.0025C12.0022 23.9794 12.0109 23.9571 12.0265 23.94L15.9365 20.03C15.9533 20.0138 15.9757 20.0048 15.999 20.0048C16.0223 20.0048 16.0447 20.0138 16.0615 20.03L19.9715 23.94C19.9875 23.9567 19.9966 23.9789 19.9971 24.002C19.9975 24.0252 19.9893 24.0476 19.974 24.065Z"
                                            fill="#717171" stroke="#717171" stroke-width="0.25"
                                            mask="url(#path-1-inside-1_2079_15996)" />
                                    </svg>
                                    <span>Products</span>
                                </a>
                            </li>
                            <li>
                                <a href="deposit" class="nav-link">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25" viewBox="0 0 32 32"
                                        fill="none">
                                        <path
                                            d="M7.25687 5.89462C8.06884 5.35208 9.02346 5.0625 10 5.0625C11.3095 5.0625 12.5654 5.5827 13.4913 6.50866C14.4173 7.43462 14.9375 8.6905 14.9375 10C14.9375 10.9765 14.6479 11.9312 14.1054 12.7431C13.5628 13.5551 12.7917 14.188 11.8895 14.5617C10.9873 14.9354 9.99452 15.0331 9.03674 14.8426C8.07896 14.6521 7.19918 14.1819 6.50866 13.4913C5.81814 12.8008 5.34789 11.921 5.15737 10.9633C4.96686 10.0055 5.06464 9.01271 5.43835 8.1105C5.81205 7.20829 6.44491 6.43716 7.25687 5.89462ZM8.29857 12.5464C8.80219 12.8829 9.3943 13.0625 10 13.0625C10.8122 13.0625 11.5912 12.7398 12.1655 12.1655C12.7398 11.5912 13.0625 10.8122 13.0625 10C13.0625 9.3943 12.8829 8.80219 12.5464 8.29857C12.2099 7.79494 11.7316 7.40241 11.172 7.17062C10.6124 6.93883 9.99661 6.87818 9.40254 6.99635C8.80847 7.11451 8.26279 7.40619 7.83449 7.83449C7.40619 8.26279 7.11451 8.80847 6.99635 9.40254C6.87818 9.99661 6.93883 10.6124 7.17062 11.172C7.40241 11.7316 7.79494 12.2099 8.29857 12.5464ZM24.7431 14.1054C23.9312 14.6479 22.9765 14.9375 22 14.9375C20.6905 14.9375 19.4346 14.4173 18.5087 13.4913C17.5827 12.5654 17.0625 11.3095 17.0625 10C17.0625 9.02346 17.3521 8.06884 17.8946 7.25687C18.4372 6.44491 19.2083 5.81205 20.1105 5.43835C21.0127 5.06464 22.0055 4.96686 22.9633 5.15737C23.921 5.34789 24.8008 5.81814 25.4913 6.50866C26.1819 7.19918 26.6521 8.07896 26.8426 9.03674C27.0331 9.99452 26.9354 10.9873 26.5617 11.8895C26.1879 12.7917 25.5551 13.5628 24.7431 14.1054ZM23.7014 7.45363C23.1978 7.11712 22.6057 6.9375 22 6.9375C21.1878 6.9375 20.4088 7.26016 19.8345 7.83449C19.2602 8.40882 18.9375 9.18778 18.9375 10C18.9375 10.6057 19.1171 11.1978 19.4536 11.7014C19.7901 12.2051 20.2684 12.5976 20.828 12.8294C21.3876 13.0612 22.0034 13.1218 22.5975 13.0037C23.1915 12.8855 23.7372 12.5938 24.1655 12.1655C24.5938 11.7372 24.8855 11.1915 25.0037 10.5975C25.1218 10.0034 25.0612 9.38763 24.8294 8.82803C24.5976 8.26844 24.2051 7.79014 23.7014 7.45363ZM7.25687 17.8946C8.06884 17.3521 9.02346 17.0625 10 17.0625C11.3095 17.0625 12.5654 17.5827 13.4913 18.5087C14.4173 19.4346 14.9375 20.6905 14.9375 22C14.9375 22.9765 14.6479 23.9312 14.1054 24.7431C13.5628 25.5551 12.7917 26.1879 11.8895 26.5617C10.9873 26.9354 9.99452 27.0331 9.03674 26.8426C8.07896 26.6521 7.19918 26.1819 6.50866 25.4913C5.81814 24.8008 5.34789 23.921 5.15737 22.9633C4.96686 22.0055 5.06464 21.0127 5.43835 20.1105C5.81205 19.2083 6.44491 18.4372 7.25687 17.8946ZM8.29857 24.5464C8.80219 24.8829 9.3943 25.0625 10 25.0625C10.8122 25.0625 11.5912 24.7398 12.1655 24.1655C12.7398 23.5912 13.0625 22.8122 13.0625 22C13.0625 21.3943 12.8829 20.8022 12.5464 20.2986C12.2099 19.7949 11.7316 19.4024 11.172 19.1706C10.6124 18.9388 9.99661 18.8782 9.40254 18.9963C8.80847 19.1145 8.26279 19.4062 7.83449 19.8345C7.40619 20.2628 7.11451 20.8085 6.99635 21.4025C6.87818 21.9966 6.93883 22.6124 7.17062 23.172C7.40241 23.7316 7.79494 24.2099 8.29857 24.5464ZM19.2569 17.8946C20.0688 17.3521 21.0235 17.0625 22 17.0625C23.3095 17.0625 24.5654 17.5827 25.4913 18.5087C26.4173 19.4346 26.9375 20.6905 26.9375 22C26.9375 22.9765 26.6479 23.9312 26.1054 24.7431C25.5628 25.5551 24.7917 26.1879 23.8895 26.5617C22.9873 26.9354 21.9945 27.0331 21.0367 26.8426C20.079 26.6521 19.1992 26.1819 18.5087 25.4913C17.8181 24.8008 17.3479 23.921 17.1574 22.9633C16.9669 22.0055 17.0646 21.0127 17.4383 20.1105C17.8121 19.2083 18.4449 18.4372 19.2569 17.8946ZM20.2986 24.5464C20.8022 24.8829 21.3943 25.0625 22 25.0625C22.8122 25.0625 23.5912 24.7398 24.1655 24.1655C24.7398 23.5912 25.0625 22.8122 25.0625 22C25.0625 21.3943 24.8829 20.8022 24.5464 20.2986C24.2099 19.7949 23.7316 19.4024 23.172 19.1706C22.6124 18.9388 21.9966 18.8782 21.4025 18.9963C20.8085 19.1145 20.2628 19.4062 19.8345 19.8345C19.4062 20.2628 19.1145 20.8085 18.9963 21.4025C18.8782 21.9966 18.9388 22.6124 19.1706 23.172C19.4024 23.7316 19.7949 24.2099 20.2986 24.5464Z"
                                            fill="#717171" stroke="#717171" stroke-width="0.25" />
                                    </svg>
                                    <span>Deposit</span>
                                </a>
                            </li>
                            <li>
                                <a href="withdraw" class="nav-link">
                                    <i class="icon icon-user-outline"></i>
                                    <span>Withdraw</span>
                                </a>
                            </li>
                             <li>
                                <a href="#" class="nav-link">
                                    <i class="icon icon-user-outline"></i>
                                    <span>  
                                     <button id="loginButton" class="btn btn-sm btn-info">Install App</button>
                                    </span>
                                </a>
                            </li>
                         
                            
                               <li>
                                <a href="logout" class="nav-link">
                                    <i class="bi bi-arrow-left"></i>
                                    <span>logout</span>
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

        </div>
    </div>

<script>
    let deferredPrompt;

// Function to show install button when desired action occurs
function showInstallButton() {
    // Assuming you have a div with id "installButtonContainer" to contain the install button
    const container = document.getElementById('installButtonContainer');
    const button = document.createElement('button');
    button.textContent = 'Install App';
    button.addEventListener('click', () => {
        deferredPrompt.prompt();
        deferredPrompt.userChoice.then((choiceResult) => {
            if (choiceResult.outcome === 'accepted') {
                console.log('User accepted the install prompt');
                // You can track the installation here if needed
            } else {
                console.log('User dismissed the install prompt');
            }
            deferredPrompt = null;
        });
    });
    container.appendChild(button);
}

// Event listener for beforeinstallprompt event
window.addEventListener('beforeinstallprompt', (event) => {
    // Prevent Chrome 67 and earlier from automatically showing the prompt
    event.preventDefault();
    // Stash the event so it can be triggered later.
    deferredPrompt = event;
    // Update UI to notify the user they can add to home screen
    showInstallButton();
});

// Event listener for the action that triggers installation
document.getElementById('loginButton').addEventListener('click', () => {
    // Check if the deferredPrompt is available
    if (deferredPrompt) {
        // Show the install prompt
        deferredPrompt.prompt();
        // Wait for the user to respond to the prompt
        deferredPrompt.userChoice.then((choiceResult) => {
            if (choiceResult.outcome === 'accepted') {
                console.log('User accepted the install prompt');
                // You can track the installation here if needed
            } else {
                console.log('User dismissed the install prompt');
            }
            // Reset the deferredPrompt variable
            deferredPrompt = null;
        });
    }
});

</script>
    <script type="text/javascript" src="public/javascript/jquery.min.js"></script>
    <script type="text/javascript" src="public/javascript/bootstrap.min.js"></script>
    <script type="text/javascript" src="public/javascript/swiper-bundle.min.js"></script>
    <script type="text/javascript" src="public/javascript/swiper.js"></script>
    <script type="text/javascript" src="public/javascript/main.js"></script>

</body>

</html><?php /**PATH /home/uniquesq/goshen-ventures.nakaa.com.ng/resources/views/user/dashboard.blade.php ENDPATH**/ ?>