<!DOCTYPE html>
<html lang="en">

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="multikit">
    <meta name="keywords" content="multikit">
    <title>Multikit - Multi-purpose Html Template</title>
    <link rel="manifest" href="public/manifest.json">
    <meta name="theme-color" content="#ff8d2f">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black">
    <meta name="apple-mobile-web-app-title" content="multikit">
    <meta name="msapplication-TileImage" content="public/assets/images/favicon/1.svg">
    <meta name="msapplication-TileColor" content="#FFFFFF">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <link rel="icon" href="public/assets/images/favicon/4.svg" type="image/x-icon">
    <link rel="shortcut icon" href="public/" type="image/x-icon">

    <!-- Google font css link  -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="stylesheet"
        href="https://fonts.googleapis.com/css2?family=Public+Sans:wght@100;200;300;400;500;600;700;800;900&display=swap">

    <!-- Loader Normalize css -->
    <link rel="stylesheet" type="text/css" href="public/assets/css/normalize.min.css">

    <!-- Bootstrap css -->
    <link id="rtl-link" rel="stylesheet" type="text/css" href="public/assets/css/vendors/bootstrap.css">

    <!-- Swiper css -->
    <link rel="stylesheet" type="text/css" href="public/assets/css/vendors/swiper/swiper-bundle.min.css">

    <!-- Remix Icon css -->
    <link rel="stylesheet" type="text/css" href="public/assets/css/remixicon.css">

    <!-- Style css -->
    <link id="change-link" rel="stylesheet" type="text/css" href="public/assets/css/style.css">
</head>

<body class="financial-color inter-body dark-body">
    <?php
        
                $sacco = DB::table('invest')->where('user_id', Auth::user()->id)->sum('capital');              
                $tr = DB::table('invest')->where('type', 10)->where('user_id', Auth::user()->id)->sum('capital');          
                $inv = DB::table('invest')->where('type', 0)->where('user_id', Auth::user()->id)->sum('capital');             
                $daily = DB::table('invest')->where('user_id', Auth::user()->id)->sum('returns');               
                $shares =  DB::table('invest')->where('type', 5)->where('user_id', Auth::user()->id)->sum('capital');              
                $cashout = DB::table('cashouts')->where('username', Auth::user()->username)->sum('amount');              
                $total_trades = DB::table('coins_trading')->where('user_id', Auth::user()->id)->sum('amount');              
                $global_withdrawal = $cashout/100;               
                //user data             
                $balances = Auth::user()->balance;
                $global = $balances / 100;           
                if(Auth::user()->country == 'Kenya'){
                    $const = 1;
                    $symb = 'KES';
                }elseif(Auth::user()->country == 'Rwanda'){
                     $const = 10;
                     $symb = 'RWF';
                }elseif(Auth::user()->country == 'Tanzania'){
                     $const = 20;
                     $symb = 'TZ';
                }elseif(Auth::user()->country == 'Uganda'){
                     $const = 30;
                     $symb = 'UGX';
                }else{
                    $const = 0.01;
                    $symb = '$';
                }
                
                $packages = DB::table('packages')->limit(4)->get();
                
          
        ?>
    <!-- Loader Box Start -->
    <div class="min-loader-wrapper">
        <img src="public/assets/images/loader/financial.gif" class="img-fluid loader" alt="">
        <div class="loader-section financial-color section-left"></div>
        <div class="loader-section financial-color section-right"></div>
    </div>
    <!-- Loader Box End -->

    <!-- Header Section Start -->
    <header class="header-style-7">
        <div class="custom-container">
            <div class="header-box">
                <div class="left-header">
                    <h2>Hello <?php echo e(Auth::user()->username); ?> <span>👋</span></h2>
                    <h5>Hassle-free trading made possible</h5>
                </div>
                <div class="right-header">
                    <a href="profile.html" class="header-profile">
                        <img src="public/assets/images/financial/dp.jpg" class="img-fluid" alt="">
                    </a>
                </div>
            </div>
        </div>
    </header>
    <!-- Header Section End -->

    <!-- Mobile Section Start -->
    <div class="mobile-style-7">
        <ul>
            <li class="active">
                <a href="home">
                    <i class="ri-home-6-line"></i>
                    <h6>Home</h6>
                </a>
            </li>
            <li>
                <a href="vip">
                    <i class="ri-bank-card-line"></i>
                    <h6>Products</h6>
                </a>
            </li>
            <li>
                <a href="deposit">
                    <i class="ri-money-euro-circle-line"></i>
                    <h6>Deposit</h6>
                </a>
            </li>
            <li>
                <a href="transactions">
                    <i class="ri-list-check-2"></i>
                    <h6>Activity</h6>
                </a>
            </li>
            <li>
                <a href="profile">
                    <i class="ri-user-3-line"></i>
                    <h6>Profile</h6>
                </a>
            </li>
        </ul>
    </div>
    <!-- Mobile Section End -->

    <!-- Card Section Start -->
    <section>
        <div class="custom-container">
            <div class="add-card-box">
                <div class="top-card-name">
                    <h4 class="name">Welcome to <?php echo e(env('APP_NAME')); ?>!</h4>
                    <h4 class="pay">Deposit, Trade & Get insights</h4>
                </div>
                <div class="bottom-card-detail">
                    <h5 class="available">Available Balance: KES.<?php echo e(Auth::user()->balance); ?></h5>
                    <a href="deposit" class="financial-btn add-card-button">Add</a>
                </div>
            </div>
        </div>
    </section>
    <!-- Card Section End -->

    <!-- Pay Option Section Start -->
    <section>
        <div class="custom-container">
            <ul class="pay-option-list">
                <li>
                    <a href="<?php echo e(env('APP_LINK')); ?>" class="pay-box send" data-bs-toggle="offcanvas">
                        <i class="ri-send-plane-line"></i>
                        <h6>App</h6>
                    </a>
                </li>
                <li>
                    <a href="withdraw" class="pay-box receive">
                        <i class="ri-download-2-line"></i>
                        <h6>withdraw</h6>
                    </a>
                </li>
                <li>
                    <a href="logout" class="pay-box exchange">
                        <i class="ri-exchange-funds-line"></i>
                        <h6>Logout</h6>
                    </a>
                </li>
                <li>
                    <a href="<?php echo e(env('APP_WHATSAPP')); ?>" class="pay-box scan">
                        <i class="ri-qr-scan-line"></i>
                        <h6>Support</h6>
                    </a>
                </li>
            </ul>
        </div>
    </section>
    <!-- Pay Option Section End -->

    <!-- Bills & Recharge Section Start -->
    <section class="section-t-space-5">
        <div class="title title-3 px-15">
            <h5>Account Details</h5>
        </div>
          <div class="row g-4 justify-content-around">
                    <div class="col-5 col-lg-6 shadow rounded bg-info">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4 p-sm-8">
                                <h4 class="stats-type mb-1">Balance</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format(Auth::user()->balance, 2)); ?>

                                </div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->

                    <div class="col-5 col-lg-6 shadow rounded bg-success">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1 text-white">Returns</h4>
                                <div class="stats-figure">KES.<?php echo e(number_format($daily, 2)); ?></div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->






                    <div class="col-5 col-lg-6 shadow bg-primary rounded">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1">Products</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format($inv, 2)); ?></div>
                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->
                    <div class="col-5 col-lg-6 shadow bg-secondary rounded">
                        <div class="app-card app-card-stat h-100">
                            <div class="app-card-body p-3 p-lg-4">
                                <h4 class="stats-type mb-1 text-white">Cashouts</h4>
                                <div class="stats-figure text-white">KES.<?php echo e(number_format($cashout, 2)); ?></div>

                            </div><!--//app-card-body-->
                            <a class="app-card-link-mask" href="#"></a>
                        </div><!--//app-card-->
                    </div><!--//col-->
                </div>
    </section>
    <!-- Bills & Recharge Section End -->

    <!-- People Section Start -->
       <?php
       $datas =   DB::table('users')->where('upline', Auth::user()->address)->get();
    
       ?>
    <section class="section-t-space-5">
        <div class="title title-3 px-15">
            <h5>People</h5>
            <a href="downlines" class="theme-color">See more</a>
        </div>
           <?php
           $peoples =   DB::table('users')->where('upline', Auth::user()->address)->get();
        
           ?>

        <ul class="people-list-box px-15">
            
                <?php if($peoples->count() > 0 ): ?>
                    <?php $__currentLoopData = $peoples; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $person): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <li>
                        <a href="downlines" class="people-box">
                            <div class="people-image">
                                <img src="public/user.png" class="img-fluid" alt="">
                            </div>
                            <h6><?php echo e($person->username); ?></h6>
                        </a>
                     </li>
                     <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?>
                <center>No teams yet</center>
                <?php endif; ?>


        
        </ul>
    </section>
    <!-- People Section End -->

    <!-- Recent Transactions Section Start -->
    <section class="section-t-space-5">
        <div class="title title-3 px-15">
            <h5>Recent Transactions</h5>
        </div>
        
          <?php 
        
        // In your controller or wherever you need this query
             $transactions = \DB::table('deposits')
            ->select('deposits.created_at as date', 'deposits.amount','deposits.status',  \DB::raw("'deposit' as type"))
            ->where('deposits.username', '=', Auth::user()->username)
            ->union(
                \DB::table('cashouts')
                    ->select('cashouts.created_at as date', 'cashouts.amount','cashouts.status', \DB::raw("'cashout' as type"))
                    ->where('cashouts.username', '=', Auth::user()->username)
            )
             ->latest('date') // Order by the 'date' column in descending order
            ->limit(3)       // Limit to the latest 4 records
            ->get();

        
        ?>

        <ul class="transactions-list px-15">
           <?php if($transactions->count() > 0): ?>
           <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trx): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
           
            <li>
                <a href="activity" class="transactions-box">
                    <div class="transactions-image">
                        <img src="public/mpesa.png" class="img-fluid" alt="">
                    </div>
                    <div class="transactions-contain">
                        <div>
                            <h5><?php echo e($trx->status); ?></h5>
                            <h6><?php echo e($trx->date); ?></h6>
                        </div>
                        <h4><?php if($trx->type =='deposit'): ?> + <?php else: ?> - <?php endif; ?> $25</h4>
                    </div>
                </a>
            </li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
           <?php else: ?>
           <center>No latest transfers</center>
           <?php endif; ?>
        </ul>
    </section>
    <!-- Recent Transactions Section End -->

 
    <!-- Your Bills Section End -->

    <!-- Divider Section Start -->
    <div class="bottom-space"></div>
    <!-- Divider Section End -->



    <!-- Bootstrap js-->
    <script src="public/assets/js/vendors/bootstrap/bootstrap.bundle.min.js"></script>

    <!-- swiper js -->
    <script src="public/assets/js/swiper-bundle.min.js"></script>
    <script src="public/assets/js/custom_swiper.js"></script>

    <!-- Loader js -->
    <script src="public/assets/js/loader.js"></script>

    <!-- Theme js-->
    <script src="public/assets/js/script.js"></script>

    <!-- Theme Settings js-->
    <script src="public/assets/js/theme-setting.js"></script>
</body>

</html><?php /**PATH /home/uniquesq/public_html/resources/views/user/dashboard.blade.php ENDPATH**/ ?>