<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\welcomeController;

/*
|--------------------------------------------------------------------------
| Web Routes:: litecoin:candlest_dc
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return redirect('/login');
});

Route::get('deploy', function (){
    return view('deploy');
});

Auth::routes();

Route::get('profile', function (){
    return view('profile');
});

Route::get('loans', function (){
    return view('estates');
});
Route::get('lucky', function (){
    return view('home');
});

Route::get('sendmail', [welcomeController::class, 'index']);
Route::get('sms', [welcomeController::class, 'message']);
Route::get('/home', [App\Http\Controllers\HomeController::class, 'index'])->name('home')->middleware('auth');
Route::get('/downlines', [App\Http\Controllers\HomeController::class, 'downlines'])->name('downlines')->middleware('auth');
Route::get('/package', [App\Http\Controllers\HomeController::class, 'quickPackage'])->name('quickpack')->middleware('auth');
Route::get('/transactions', [App\Http\Controllers\HomeController::class, 'trxHome'])->name('trxHome')->middleware('auth');
Route::get('/dashboard', [App\Http\Controllers\HomeController::class, 'dashboard'])->name('dashboard')->middleware('auth');
Route::post('/approve', [App\Http\Controllers\HomeController::class, 'approveCashouts'])->name('approve')->middleware('auth');
Route::get('/investment', [App\Http\Controllers\InvestController::class, 'index'])->name('investment')->middleware('auth');
Route::get('/opensavings', [App\Http\Controllers\InvestController::class, 'openSavings'])->name('investment')->middleware('auth');
Route::get('/closedsavings', [App\Http\Controllers\InvestController::class, 'closedSavings'])->name('investment')->middleware('auth');
Route::get('/real-estates', [App\Http\Controllers\InvestController::class, 'realEstates'])->name('real-estates')->middleware('auth');

Route::post('/real-estates', [App\Http\Controllers\InvestController::class, 'realestateTrades'])->name('realestateTrades')->middleware('auth');
Route::post('/investment', [App\Http\Controllers\InvestController::class, 'post'])->name('investment')->middleware('auth');
Route::get('/bundles', [App\Http\Controllers\InvestController::class, 'bundles'])->name('investment')->middleware('auth');
Route::get('/vip', [App\Http\Controllers\InvestController::class, 'index'])->name('investment')->middleware('auth');
Route::post('/shorterm', [App\Http\Controllers\InvestController::class, 'shortTerm'])->name('investment')->middleware('auth');
Route::get('/shareholding', [App\Http\Controllers\InvestController::class, 'shareholding'])->name('shareholding')->middleware('auth');
Route::post('/shareholding', [App\Http\Controllers\InvestController::class, 'shareholdingAction'])->name('shareholding')->middleware('auth');
Route::post('/auto', [App\Http\Controllers\InvestController::class, 'autotrade'])->name('investment')->middleware('auth');
Route::get('/process', [App\Http\Controllers\testProcessor::class, 'processor'])->name('process')->middleware('auth');
Route::get('/trade', [App\Http\Controllers\tradingMachine::class, 'index'])->name('trade')->middleware('auth');
Route::get('/binary', [App\Http\Controllers\tradingMachine::class, 'binaryIndex'])->name('trade')->middleware('auth');
Route::get('/binaryquide', [App\Http\Controllers\tradingMachine::class, 'binaryMain'])->name('trade')->middleware('auth');
Route::post('/binaryquide', [App\Http\Controllers\tradingMachine::class, 'binaryQuide'])->name('trade')->middleware('auth');

Route::get('/admex-ninja', [App\Http\Controllers\tradingMachine::class, 'admex'])->name('admex')->middleware('auth');
Route::post('/admex-ninja', [App\Http\Controllers\tradingMachine::class, 'admex_post'])->name('admex_post')->middleware('auth');

Route::get('/currency', [App\Http\Controllers\tradingMachine::class, 'currency'])->name('currency')->middleware('auth');
Route::get('/cards', [App\Http\Controllers\tradingMachine::class, 'cardsIndex'])->name('cards')->middleware('auth');
Route::post('/cards', [App\Http\Controllers\tradingMachine::class, 'cardsPost'])->name('cards')->middleware('auth');


Route::post('/currency', [App\Http\Controllers\tradingMachine::class, 'tradeCurrency'])->name('currency')->middleware('auth');
Route::post('/trade', [App\Http\Controllers\tradingMachine::class, 'machine'])->name('trade')->middleware('auth');
Route::post('/wallet', [App\Http\Controllers\transferEngine::class, 'transfer'])->name('wallet')->middleware('auth');
Route::get('/wallet', [App\Http\Controllers\transferEngine::class, 'index'])->name('wallet')->middleware('auth');
Route::get('/coin', [App\Http\Controllers\bitcoinController::class, 'index'])->name('bitcoin')->middleware('auth');
Route::get('/litecoin', [App\Http\Controllers\litecoinController::class, 'index'])->name('litecoin')->middleware('auth');
Route::get('/ethereum', [App\Http\Controllers\ethereumController::class, 'index'])->name('ethereum')->middleware('auth');
Route::get('/monero', [App\Http\Controllers\moneroController::class, 'index'])->name('monero')->middleware('auth');
Route::get('/luno', [App\Http\Controllers\moneroController::class, 'luno'])->name('luno')->middleware('auth');
Route::get('/withdraw', [App\Http\Controllers\fundsEngine::class, 'withdrawal_view'])->name('withdraw')->middleware('auth');
Route::get('/deposit', [App\Http\Controllers\fundsEngine::class, 'deposit_view'])->name('deposit')->middleware('auth');
Route::get('/management', [App\Http\Controllers\autoMachine::class, 'management_view'])->name('management')->middleware('auth');
Route::get('/bots', [App\Http\Controllers\autoMachine::class, 'bots_view'])->name('bots')->middleware('auth');
Route::get('/auto', [App\Http\Controllers\autoMachine::class, 'tradeAuto'])->name('bots')->middleware('auth');


Route::post('/bitcoin', [App\Http\Controllers\bitcoinController::class, 'trade'])->name('bitcoin')->middleware('auth');
Route::post('/ethereum', [App\Http\Controllers\ethereumController::class, 'trade'])->name('ethereum')->middleware('auth');
Route::post('/litecoin', [App\Http\Controllers\litecoinController::class, 'trade'])->name('litecoin')->middleware('auth');
Route::post('/monero', [App\Http\Controllers\moneroController::class, 'trade'])->name('monero')->middleware('auth');
Route::post('/luna', [App\Http\Controllers\moneroController::class, 'lunaAction'])->name('luna')->middleware('auth');
Route::post('/withdraw', [App\Http\Controllers\fundsEngine::class, 'withdraw'])->name('withdraw')->middleware('auth');
Route::post('/bots', [App\Http\Controllers\autoMachine::class, 'bots'])->name('bots')->middleware('auth');
Route::post('/actions', [App\Http\Controllers\tradingMachine::class, 'actions'])->name('trade')->middleware('auth');
Route::get('/spin', [App\Http\Controllers\tradingMachine::class, 'spinning'])->name('spin')->middleware('auth');
Route::get('/delete_post', [App\Http\Controllers\tradingMachine::class, 'spin_post'])->name('delete_post')->middleware('auth');

Route::get('/logout', function () {
Auth::logout();
return redirect('/login');
});
