<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta http-equiv="X-UA-Compatible" content="IE=edge">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
  <title>Document</title>
  
</head>
<style>
*{
box-sizing:border-box;
padding: 0;
margin: 0;
outline: none;

}
body{
font-family: Open sans;
display: flex;
justify-content: center;
align-items: center;
height: 100vh;
overflow: hidden;
background-color: #1371b1;
background-size: cover;
width:fit-content;


}
.mainbox{
position: relative;
width: 500px;
height: 500px;

}

.mainbox:after{
position: absolute;
content: '';
width: 32px;
height: 32px;
background: url('arrow-left.png') no-repeat;
background-size: 32px ;
right: -30px;
top: 50%;
transform: translateY(-50%);
}

.box{
width: 100%;
height: 100%;
position: relative;
border-radius: 50%;
border: 10px solid #fff;
overflow: hidden;
transition: all ease 5s;

}

span{
width: 50%;
height: 50%;
display: inline-block;
position: absolute;


}
.span1{

clip-path: polygon(0 92%, 100% 50%, 0 8%);
background-color: #ffeb3b;
top: 120px;
left: 0;


}

.span2{

clip-path: polygon(100% 92%, 0 50%, 100% 8%);
background-color: #e91e63;
top: 120px;
right: 0;


}

.span3{

clip-path: polygon(50% 0%, 8% 100%, 92% 100%);
background-color: #4caf50;
bottom: 0;
left: 120px;


}

.span4{

clip-path: polygon(50% 100%, 92% 0, 8% 0);
background-color: #3f51b5;
top: 0;
left: 120px;


}
.box2{

  width: 100%;
  height: 100%;
  transform: rotate(-135deg);
}

span b{
width: 65px;
height: 65px;
line-height: 65px;
border-radius: 50px;
font-size: 26px;
text-align: center;
background-color: #fff;
position: absolute;
top: 50%;
left: 50%;
transform: translate(-50%, -50%);
box-shadow: inset 0 3px 3px 0 #717171;

}

.spin{

  position: absolute;
  top: 50%;
  left: 50%;
  transform: translate(-50%, -50%);
  width: 75px;
  height: 75px;
  border-radius: 50%;
  border: 4px solid #fff;
  background-color: #ff5722;
  color: #fff;
  box-shadow: 0 5px 20px #000;
  font-weight: bold;
  font-size: 22px;
  cursor: pointer;
}
.spin:active{
width: 70px;
height: 70px;
font-size: 20px;





}
.mainbox.animate:after{
  animation: animateArrow 0.7s ease infinite;


}

@keyframes animateArrow{
  50%{
    right: -40px;
  }
}

</style>
<body>


  <div id="mainbox" class="mainbox">
     
    <div id="box" class="box">
            <div class="box1">
                <span class="span1"><b>5</b></span>
                <span class="span2"><b>10</b></span>
                <span class="span3"><b>20</b></span>
                <span class="span4"><b>30</b></span>

            </div>

            <div class="box2">
              <span class="span1"><b>0</b></span>
              <span class="span2"><b>15</b></span>
              <span class="span3"><b>25</b></span>
              <span class="span4"><b>35</b></span>

          </div>
    </div>
    <button onclick="myfunction()" class="spin">SPIN</button>
        @if (\Session::has('success'))
        <div class="alert alert-success">
            <ul>
                <li>{!! \Session::get('success') !!}</li>
            </ul>
        </div>
    @endif

    @if (\Session::has('error'))
    <div class="alert alert-danger">
        <ul>
            <li>{!! \Session::get('error') !!}</li>
        </ul>
    </div>
@endif
     <div class="card m-2">
         <div class="card-header"> Welcome To Spin Zone! Earn By Your Luck</div>
         <div class="card-body">
             <h4>ACCOUNT BALANCE : <b> KSH{{Auth::user()->balance}}</b></h4>
             <a href="home"><button class="bg-primary">Go Home</button></a>
         </div>
     </div>
  </div>

<script>
function myfunction(){
var x = 0; //min value
var y =10000; //maximum value

var deg = Math.floor(Math.random() * (x - y) + y);


document.getElementById('box').style.transform = "rotate("+deg+"deg)";

var element = document.getElementById('mainbox');
element.classList.remove('animate');
setTimeout(function(){
  element.classList.add('animate');
}, 5000);

//others
// $('.alert').alert()
console.log(deg);
let amount = deg/10;
console.log(amount);
//alert("you have earned "+amount);
const myTimeout = setTimeout(spinUpdate, 5000);

function spinUpdate() {
    document.location.href="{!! route('delete_post'); !!}";
}

function myStopFunction() {
  clearTimeout(myTimeout);
}



  

//end



}


</script>

<!-- other js  globals-->
<script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/popper.js@1.12.9/dist/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@4.0.0/dist/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
</body>
</html>