@extends('layouts.main')

@section('content')
<br><br>
<div class="container">
    <div class="row">
        <div class="col-md-12 mb-2">
            <div class="card bg-white">
                <div class="card-header">{{ __('OPEN SAVINGS ACCOUNT') }}</div>

                <div class="card-body ">
                    @if (session('status'))
                        <div class="alert alert-success" role="alert">
                            {{ session('status') }}
                        </div>
                    @endif

                    @if($errors->any())
                        <div class="alert alert-warning">{{$errors->first()}}</div>
                    @endif
                    <form method="POST" action="investment" >
                        @csrf
                     <h4 class="card-title"> EARN WITH OPEN SAVINGS</h4>
                                <p class="card-description text-dark"> <em>select package and enter capital</em>  </p>
                                  <div class="form-group">
                                    <label for="exampleFormControlSelect1">SELECT PACKAGE</label>
                                    <select class="form-control" name="package" id="exampleFormControlSelect1">

                                      <option value="20">(20% in 72Hours)+Capital</option>
                                      <option value="45">(45% in 6Days)+Capital</option>
                                      <option value="70">(70% in 9Days)+ Capital</option>
                                      
                                    </select>
                                  </div>
                                <div class="form-group">
                                  <label></label>
                                  <input type="number" required name="amount" class="form-control form-control-lg" placeholder="Enter Amount To Invest" aria-label="Capital">
                                </div>

                                <button type="submit" class="btn btn-primary">Submit now</button>
                    </form>
                </div>
            </div>
        </div>
        {{-- create table for runing investments --}}
        <?php
        $datas =   DB::table('invest')->where('type', 0)->where('user_id', Auth::user()->id)->get();

        ?>
          <hr>
          <div class="col-lg-12 stretch-card">
            <div class="card bg-success">
              <div class="card-body">
                <h4 class="card-title">User Open Savings Table</h4>

                </p>
                <div class="table-responsive">
                  <table class="table table-bordered table-contextual">
                    <thead>
                      <tr>
                        <th> # </th>
                        <th> capital </th>
                        <th> returns </th>
                        <th> start date </th>
                        <th> status </th>
                      </tr>
                    </thead>
                    <tbody>
                        @foreach ($datas as $data )


                      <tr class="table-info">
                        <td> 1 </td>
                        <td> {{ $data->capital }} </td>
                        <td> {{ $data->returns }} </td>
                        <td> {{ $data->date }} </td>
                        <td> 
                        @if ($data->status == 1)
                            Running...
                        @endif
                        @if ($data->status == 2)
                            Expired!!
                        @endif
                    </td>
                      </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
       {{-- end of the table --}}
    </div>
</div>
@endsection