<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;

class ethereumController extends Controller
{
    public function index(){
        return view('buycoin.eth');
    }
    public function trade(Request $req){
        $amount = $req->amount;
        $balance = Auth::user()->balance;
        $id = Auth::user()->id;
        $new_balance = $balance - $amount;


        if ($amount > $balance) {
            return back()->with('error', "you do not have enough account balance to buy ethereum worth $amount ");
        }
        if ($amount < 500) {
            return back()->with('error', "Minimum amount to buy any crypto is 500ksh");
        }
        //katapes

        DB::table('users')->where('id',$id)->update([
                'balance' => $new_balance,
                'ethereum' => $amount,
        ]);
        return back()->with('success', "you have successfully purchased ethereum worth $amount ");
    }

}
