<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;

use Illuminate\Http\Request;

use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;

class InvestController extends Controller
{
    
    public function openSavings(){
               //import my trades which haven't matured
        $trades = DB::table('invest')->where('status', 1)->where('type', 0)->where('user_id', Auth::user()->id)->get();
        //we use foreach to get them all
        foreach ($trades as $trade) {
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now();
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = $trade->date;

                   $diff_in_days = $to->diffInHours($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
// dd($diff_in_days);
               if($diff_in_days >= $period){
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                                      //calculate net profits
                                      $net_profit = $profit;
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + $net_profit;

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['balance' => $new_balance]);
                           }

                           //mark paid
                           $markPaid =DB::table('invest')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update([
                               'days_paid' => $diff_in_days,
                               'status' => 2
                               ]);
               }


       }
    //    *****************************************************************//
    
        
        return view('open');
        
    }

    public function closedSavings(){
        
         //import my trades which haven't matured
        $trades = DB::table('invest')->where('status', 1)->where('type', 0)->where('user_id', Auth::user()->id)->get();
        //we use foreach to get them all
        foreach ($trades as $trade) {
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now();
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = $trade->date;

                   $diff_in_days = $to->diffInHours($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
// dd($diff_in_days);
               if($diff_in_days >= $period){
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                                      //calculate net profits
                                      $net_profit = $profit;
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + $net_profit;

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['balance' => $new_balance]);
                           }

                           //mark paid
                           $markPaid =DB::table('invest')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update([
                               'days_paid' => $diff_in_days,
                               'status' => 2
                               ]);
               }


       }
    //    *****************************************************************//
    
    return view('closed');
    }
    public function index (){

        return view ('investment');

    }

   public function post (Request $req){
      //asign variables to request fields
      
      //dd($req);
      
      $package = $req->percentage ;
      $min = 3;
     
          $dp =0;
          $percentage = $req->daily * 0.01;
         $type = $req->type;
      
      //dd($percentage);
      $amount = $req->capital;
      $balance = Auth::user()->balance;
      $ret = $amount * $percentage;
      $id= Auth::user()->id;
      //switch packages
      
            //handle time and day
        $now = Carbon::now();
        $day = Carbon::now()->toDateTimeString();

        $daysToAdd = 3;
        
  
      //dd($daysToAdd);
     //add days
     $date = $now->addDays($daysToAdd);

     //validate investments
     if($amount > $balance){

        return back()->withErrors(['Ooops!!' => ' You do not have enough balance to trade with us deposit and start trading!']);
     }

     if($amount < $min){

        return back()->withErrors(['Ooops!!' => "Minimum Price for this Trade is $min $!"]);
     }

      //create new investment instance
      $invest = DB::table('invest')->insert([
        'user_id' => $id,
        'status' => 1,
        'period' => $daysToAdd,
        'returns' => $ret,
        'type' => 0,
        'capital' => $amount,
        'days_paid' => $dp,
        'upline_bonus' => $amount*0.05,
        'date' => $day,
        'end_date' => $date
       ]);

       if($invest){
           $new_cash = $balance - $amount;
           DB::table('users')->where('id', $id)->update([
               'balance' => $new_cash
           ]);
            //select out the upline 
            $upline = DB::table('users')->where('username', Auth::user()->upline)->first();
            if($upline){
            //upline balance
            $balance = $upline->balance;
            //update his bala
            $bonus = 0.05 * $amount;
            //set new amount 
            $new_balance = $balance + $bonus;
            
            //update upline 
             DB::table('users')->where('username', Auth::user()->upline)->update(['balance'=> $new_balance]);
            } 

//return back
      return back()->withErrors(['success' => 'Your Product Purchase Was Successful']);



       }elseif(!$invest){

       return back()->withErrors(['oops' => ' Error Encountered during investment!']);
       }

    }
    
    public function shortTerm (Request $req){
        //asign variables to request fields
        
        $package = $req->package;
        $percentage = $package * 0.01 + 1;
        
        //dd($percentage);
        $amount = $req->amount;
        $balance = Auth::user()->balance;
        $ret = $amount * $percentage;
        $id= Auth::user()->id;
        //switch packages
        
              //handle time and day
          $now = Carbon::now();
          $day = Carbon::now()->toDateTimeString();
  
          $daysToAdd = 1;
          
          // return $day;
        switch ($package) {
            //percenteges
                        case '3.5':
                          # code...
                          $daysToAdd = 6;
                          break;
                          
                         case '8':
                          # code...
                           $daysToAdd = 12;
                          break;
                          
                       case '18':
                          # code...
                        $daysToAdd = 24;   
                          break;
 
                      }
        //dd($daysToAdd);
       //add days
       $date = $now->addHours($daysToAdd);
  
       //validate investments
       if($amount > $balance){
  
          return back()->withErrors(['Ooops!!' => ' You do not have enough balance to trade with us deposit and start trading!']);
       }
  
       if($amount < 501){
  
          return back()->withErrors(['Ooops!!' => ' Minimum investment is 500!']);
       }
  
        //create new investment instance
        $invest = DB::table('invest')->insert([
          'user_id' => $id,
          'status' => 1,
          'period' => $daysToAdd,
          'returns' => $ret,
          'capital' => $amount,
          'days_paid' => 0,
          'date' => $day,
          'end_date' => $date
         ]);
  
         if($invest){
             $new_cash = $balance - $amount;
             DB::table('users')->where('id', $id)->update([
                 'balance' => $new_cash
             ]);
  //select out the upline 
  $upline = DB::table('users')->where('username', Auth::user()->upline)->first();
  if($upline){
  //upline balance
  $balance = $upline->balance;
  //update his bala
  $bonus = 0.05 * $amount;
  //set new amount 
  $new_balance = $balance + $bonus;
  
  //update upline 
   DB::table('users')->where('username', Auth::user()->upline)->update(['balance'=> $new_balance]);
  } 
  
  //return back
        return back()->withErrors(['success' => 'Investment Success']);
  
  
  
         }elseif(!$invest){
  
         return back()->withErrors(['oops' => ' Error Encountered during investment!']);
         }
  
  
  
      }
    

    public function autotrade (Request $req){
     //asign variables to request fields

     $amount = $req->amount;
     $balance = Auth::user()->balance;
     $ret = $amount * 0.11;
     $id= Auth::user()->id;

     //handle time and day
     $now = Carbon::now();
     $day = Carbon::now()->toDateTimeString();

       $daysToAdd = 5;
       $date = $now->addDays($daysToAdd);




    // return $day;

    //validate investments
    if($amount > $balance){

       return back()->withErrors(['Ooops!!' => ' You do not have enough balance to trade with us deposit and start trading!']);
    }
    //set minimum

    if($amount < 300){

        return back()->withErrors(['Ooops!!' => ' Minimum capital for trading is 300ksh!']);
     }


     //create new investment instance
     $invest = DB::table('bots')->insert([
       'user_id' => $id,
       'status' => 1,
       
       'returns' => $ret,
       'capital' => $amount,
       'days_paid' => 0,
       'date' => $day,
       'end_date' => $date
      ]);

      if($invest){

        $new_cash = $balance - $amount;
        DB::table('users')->where('id', $id)->update([
            'balance' => $new_cash
        ]);

     return back()->withErrors(['success' => 'Trading went successfully , check your balance after every 24hrs']);



      }elseif(!$invest){

      return back()->withErrors(['oops' => ' Error Encountered during trading!']);
      }




    }
    
    
    public function realEstates(){
        return view('estates');
    }
    
    public function realestateTrades(Request $req){
             //asign variables to request fields

      $amount = $req->amount;
      $balance = Auth::user()->balance;
      $ret = $amount * 0.1;
      $id= Auth::user()->id;

      //handle time and day
      $now = Carbon::now();
      $day = Carbon::now()->toDateTimeString();

        $daysToAdd = 5;
        $date = $now->addDays($daysToAdd);




     // return $day;

     //validate investments
     if($amount > $balance){

        return back()->withErrors(['Ooops!!' => ' You do not have enough balance to trade with us deposit and start trading!']);
     }

     if($amount < 1000){

        return back()->withErrors(['Ooops!!' => ' Minimum Trading capital is 1000KES!']);
     }

      //create new investment instance
      $invest = DB::table('invest')->insert([
        'user_id' => $id,
        'status' => 1,
        'type' => 10,
        'returns' => $ret,
        'capital' => $amount,
        'days_paid' => 0,
        'date' => $day,
        'end_date' => $date
       ]);

       if($invest){
           $new_cash = $balance - $amount;
           DB::table('users')->where('id', $id)->update([
               'balance' => $new_cash
           ]);

      return back()->withErrors(['success' => 'Your margin trade initiated  successfully']);



       }elseif(!$invest){

       return back()->withErrors(['oops' => ' Error Encountered during investment!']);
       }



    }
    
    public function shareholding(){
        return view('shares');
    }
    
    public function shareholdingAction(Request $req){
                     //asign variables to request fields

      $amount = $req->amount;
      $balance = Auth::user()->balance;
      $ret = $amount * 0.075;
      $id= Auth::user()->id;

      //handle time and day
      $now = Carbon::now();
      $day = Carbon::now()->toDateTimeString();

      $daysToAdd = 5;
      $date = $now->addDays($daysToAdd);
     // return $day;
     
     //validate investments
     if($amount > $balance){

        return back()->withErrors(['Ooops!!' => ' You do not have enough balance to buy shares with us deposit and start trading!']);
     }

     if($amount < 500){

        return back()->withErrors(['Ooops!!' => ' Minimum shares amount is 500ksh!']);
     }

      //create new investment instance
      $invest = DB::table('invest')->insert([
        'user_id' => $id,
        'status' => 1,
        'type' => 5,
        'returns' => $ret,
        'capital' => $amount,
        'days_paid' => 0,
        'date' => $day,
        'end_date' => $date
       ]);

       if($invest){
           $new_cash = $balance - $amount;
           DB::table('users')->where('id', $id)->update([
               'balance' => $new_cash
           ]);
           
           //update upline
           
           
           //return bac

      return back()->withErrors(['success' => 'Your shares was bought successfully']);



       }elseif(!$invest){

       return back()->withErrors(['oops' => ' Error Encountered during buying shares!']);
       }


    }
    
    public function bundles(){
       return view('user.orders');
    }
}