<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Auth;
use WisdomDiala\Cryptocap\Facades\Cryptocap;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
     
     public function approveCashouts(Request $req){
         $amount = $req->amount;
         $id = $req->id;
         
       //  dd($id);
        // $phone = $req->phone;
         //update csts status
         $update = DB::table('cashouts')->where('id', $id)->update([
             'status' => "Approved"
             
             ]);
             
             //send mail
             
             //return back the user
             return back()->with('success', 'Approved successfully');
     }
    public function index()
    {

        
    //import my trades which haven't matured
        $trades = DB::table('invest')->where('status', 1)->where('type', 0)->where('user_id', Auth::user()->id)->get();
        if($trades->count() > 0)
        {
                if(Auth::user()->status == "inactive")
                {
                    DB::table('users')->where('id', Auth::user()->id)->update(['status'=> "active"]);
                }
        }
        //we use foreach to get them all
        foreach ($trades as $trade) {
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now()->addHour(3);
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = $trade->date;

                   $diff_in_days = $to->diffInDays($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
 //var_dump($days_not_paid);
               if($days_not_paid >= 0){
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                                      //calculate net profits
                                      $net_profit = $profit ;
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + $net_profit;

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['balance' => $new_balance]);
                           }

                           //mark paid
                           $markPaid =DB::table('invest')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update([
                               'days_paid' => $diff_in_days,
                               'status' => 2
                               ]);
               }


       }
    //    *****************************************************************//


            return view ('user.dashboard');


    }



    public function dashboard (){
  //import my trades which haven't matured
        $trades = DB::table('invest')->where('status', 1)->where('type', 0)->where('user_id', Auth::user()->id)->get();
        //we use foreach to get them all
        foreach ($trades as $trade) {
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get trading period
                   $period = $trade->period;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now()->addHour(3);
                   //assumed date of start of investing
                   $from_fake = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');
                   //real end date
                   $from = $trade->date;

                   $diff_in_days = $to->diffInDays($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;
 //dd($diff_in_days);
               if($diff_in_days >= 3){
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get capital
                           $capital = $trade->capital;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                                      //calculate net profits
                                      $net_profit = $profit;
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + $net_profit;

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['balance' => $new_balance]);
                           }

                           //mark paid
                           $markPaid =DB::table('invest')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update([
                               'days_paid' => $diff_in_days,
                               'status' => 2
                               ]);
               }


       }
    //    *****************************************************************//
        

        return view ('user.dashboard');
    }

    public function downlines (){
        return view ('user.downlines');
    }
    
    public function trxHome(){
        return view('transactions');
    }
    
   public function quickPackage(Request $request)
    {
       //dd($request);
       
        $p = request()->query('p');
        $amt = request()->query('amt');
        $p_details = DB::table('packages')->where('id', $p)->first();
        $price = $p_details->price;
        $returns = $amt * ($p_details->returns * 0.01 );
     
       //dd($returns);
        $amount = request()->query('amt');
        $day = Carbon::now();
        $dayPay = Carbon::now()->addDays(1);
        $balance = Auth::user()->balance;
        $id = Auth::user()->id;
        $new_cash = $balance - $amount;
        //nge createn investment
     
        //validate investments 10k < 1k
         if($new_cash < 0)
         {
            return back()->with('error','insufficient account balance!');
         }
        
      //create new investment instance
      $invest = DB::table('invest')->insert([
        'user_id' => Auth::user()->id,
        'status' => 1,
        'period' => 30,
        'returns' => $returns,
        'type' => 0,
        'capital' => $amount,
        'days_paid' => $p_details->days,
        //'next_payment' => $dayPay,
        'upline_bonus' => $amount*0.1,
        'date' => $day,
        'end_date' => $day
      ]);

      if($invest){
         
          DB::table('users')
          ->where('id', $id)
          ->update([
              'balance' => $new_cash,
              'status' => 1
          ]);
            //select out the upline 
            $upline = DB::table('users')->where('address', Auth::user()->upline)->first();
            if($upline)
            {
                //upline balance
                $balance = $upline->balance;
                //update his bala
                $bonus = 0.1 * $amount;
                //set new amount 
                $new_balance = $balance + $bonus;
                //update upline 
                 DB::table('users')->where('address', Auth::user()->upline)->update(['balance'=> $new_balance]);
            } 

     //return back
      return back()->with('success','processed successfully!');
      
      }
        
    }
}
