<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;

use Illuminate\Support\Facades\DB;

use Carbon\Carbon;

use WisdomDiala\Cryptocap\Facades\Cryptocap;

class DemoCron extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'demo:cron';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Zungura comming after 5mins';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        //\Log::info("Cron is working fine!");

        /*
           Write your database logic we bellow:
           checking running investments and update them;

        */
        //import data from database and test them up
        $trades = DB::table('invest')->get();
        //we use foreach to get them all
        foreach ($trades as $trade) {
                   //get profit foreach user
                   $profit=$trade->returns;
                   //get days paid so far
                   $paid = $trade->days_paid;
                    // $to = Carbon::parse($trade->end_date);
                   $from_yangu = Carbon::parse($trade->end_date);
                   //$to = \Carbon\Carbon::createFromFormat('Y-m-d H:s:i', '2015-5-5 3:30:34');
                   $to = Carbon::now();
                   //assumed date of start of investing
                   $from = Carbon::createFromFormat('Y-m-d H:s:i', '2022-2-16 9:30:34');

                   $diff_in_days = $to->diffInDays($from);
                   //compare days paid with difference
                   $days_not_paid = $diff_in_days - $paid;

               if($days_not_paid > 0){
                           //get id of users to be paid
                           $id =  $trade->user_id;
                           //get id of that running investment
                           $invest_id = $trade->id;
                           //select those users
                           $users = DB::table('users')->where('id', $id)->get();
                           //loop through each unpaid person
                           foreach ($users as $user){
                                      //initialize their balance
                                       $balance = $user ->balance;
                                       //add profits to balance
                                       $new_balance = $balance + 100;

                                   //pay them
                                   $affected = DB::table('users')
                                   ->where('id', $id)
                                   //update to new balance
                                   ->update(['balance' => $new_balance]);
                           }

                           //mark paid
                           $markPaid =DB::table('invest')
                           ->where('id', $invest_id)
                           //set everyone paid
                           ->update(['days_paid' => $diff_in_days]);
               }


       }
    //    *****************************************************************//
      //another logic for updating coin prices

      $btc = Cryptocap::getSingleAsset('bitcoin')->data->priceUsd;
      $eth = Cryptocap::getSingleAsset('ethereum')->data->priceUsd;
      $mno = Cryptocap::getSingleAsset('monero')->data->priceUsd;
      $ltc = Cryptocap::getSingleAsset('litecoin')->data->priceUsd;


     DB::table('coin_prices')->where('id', 1)->update([
        'price' => $btc,

       ]);

       DB::table('coin_prices')->where('id', 2)->update([
        'price' => $eth,

       ]);

       DB::table('coin_prices')->where('id', 3)->update([
        'price' => $ltc,

       ]);


     DB::table('coin_prices')->where('id', 4)->update([
        'price' => $mno,

       ]);

          /**
           * end of database logic
           */


        $this->info('Demo:Cron Cummand Run successfully!');
    }
}
